/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.chunkLoader;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LoaderBlockEntity
extends KineticBlockEntity {
    public LoaderBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                serverLevel.setChunkForced(new ChunkPos((BlockPos)this.getBlockPos()).x + i, new ChunkPos((BlockPos)this.getBlockPos()).z + j, Math.abs(this.getSpeed()) >= (float)(128 * Math.max(Math.abs(i), Math.abs(j))));
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean superAdded = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!superAdded) {
            return false;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        int radius = (int)Math.abs(this.getSpeed()) / 128 * 2 + 1;
        CreateLang.builder().space().addTo(tooltip);
        new LangBuilder("createendertransmission").add(Component.translatable((String)"createendertransmission.chunk_loader.loaded", (Object[])new Object[]{radius * radius})).style(ChatFormatting.GREEN).forGoggles(tooltip);
        return true;
    }
}

