/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.shearpin;

import com.google.common.base.Predicates;
import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.AbstractBEShaftBlock;
import com.hlysine.create_connected.content.shearpin.ShearPinBlockEntity;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ShearPinBlock
extends AbstractBEShaftBlock<ShearPinBlockEntity> {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ShearPinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<ShearPinBlockEntity> getBlockEntityClass() {
        return ShearPinBlockEntity.class;
    }

    public BlockEntityType<? extends ShearPinBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.SHEAR_PIN.get();
    }

    public void tick(@NotNull BlockState pState, ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof ShearPinBlockEntity)) {
            return;
        }
        ShearPinBlockEntity kte = (ShearPinBlockEntity)be;
        if (!kte.isOverStressed()) {
            return;
        }
        if (!pLevel.isClientSide) {
            pLevel.destroyBlock(pPos, false);
            Vec3 center = pPos.getCenter();
            pLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, center.x, center.y, center.z, 5, 0.1, 0.1, 0.1, 0.05);
            AdvancementBehaviour.tryAward((BlockEntity)kte, CCAdvancements.SHEAR_PIN);
        }
    }

    public static boolean isShaft(BlockState state) {
        return CCBlocks.SHEAR_PIN.has(state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.getValue((Property)AXIS));
    }

    public float getParticleTargetRadius() {
        return 0.35f;
    }

    public float getParticleInitialRadius() {
        return 0.125f;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack item, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(item)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)item.getItem(), player, hand, ray);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super((Predicate)Predicates.or((com.google.common.base.Predicate)Predicates.or(arg_0 -> ((BlockEntry)AllBlocks.SHAFT).has(arg_0), arg_0 -> ((BlockEntry)AllBlocks.POWERED_SHAFT).has(arg_0)), arg_0 -> CCBlocks.SHEAR_PIN.has(arg_0)), state -> (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS), (Property)RotatedPillarKineticBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.getItem() instanceof BlockItem && ((BlockItem)i.getItem()).getBlock() instanceof AbstractSimpleShaftBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> ShaftBlock.pickCorrectShaftType((BlockState)s, (Level)world, (BlockPos)offset.getBlockPos())));
            }
            return offset;
        }
    }
}

