/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.config;

import net.minecraft.Util;
import net.minecraft.util.Unit;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import plus.dragons.createenchantmentindustry.config.CEIClientConfig;
import plus.dragons.createenchantmentindustry.config.CEIEnchantmentsConfig;
import plus.dragons.createenchantmentindustry.config.CEIFluidsConfig;
import plus.dragons.createenchantmentindustry.config.CEIKineticsConfig;
import plus.dragons.createenchantmentindustry.config.CEIProcessingConfig;
import plus.dragons.createenchantmentindustry.config.CEIServerConfig;
import plus.dragons.createenchantmentindustry.config.CEIStressConfig;

public class CEIConfig {
    private static final CEIClientConfig CLIENT_CONFIG = new CEIClientConfig();
    private static final CEIServerConfig SERVER_CONFIG = new CEIServerConfig();
    private static ModConfigSpec CLIENT_SPEC;
    private static ModConfigSpec SERVER_SPEC;

    public CEIConfig(ModContainer modContainer) {
        CLIENT_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            CLIENT_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec));
        SERVER_SPEC = (ModConfigSpec)Util.make((Object)((ModConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            SERVER_CONFIG.registerAll((ModConfigSpec.Builder)builder);
            return Unit.INSTANCE;
        }).getValue()), spec -> modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec));
    }

    public static CEIClientConfig client() {
        return CLIENT_CONFIG;
    }

    public static CEIServerConfig server() {
        return SERVER_CONFIG;
    }

    public static CEIKineticsConfig kinetics() {
        return CEIConfig.SERVER_CONFIG.kinetics;
    }

    public static CEIStressConfig stress() {
        return CEIConfig.SERVER_CONFIG.kinetics.stressValues;
    }

    public static CEIFluidsConfig fluids() {
        return CEIConfig.SERVER_CONFIG.fluids;
    }

    public static CEIEnchantmentsConfig enchantments() {
        return CEIConfig.SERVER_CONFIG.enchantments;
    }

    public static CEIProcessingConfig processing() {
        return CEIConfig.SERVER_CONFIG.processing;
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (SERVER_SPEC == spec) {
            SERVER_CONFIG.onLoad();
        } else if (CLIENT_SPEC == spec) {
            CLIENT_CONFIG.onLoad();
        }
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (SERVER_SPEC == spec) {
            SERVER_CONFIG.onReload();
        } else if (CLIENT_SPEC == spec) {
            CLIENT_CONFIG.onReload();
        }
    }
}

