/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.simibubi.create.AllItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlock;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceFuel;

public abstract class BlazeExperienceBlock<T extends BlazeExperienceBlockEntity>
extends BlazeBlock<T> {
    public BlazeExperienceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean notConsume;
        BlazeExperienceBlockEntity blockEntity = (BlazeExperienceBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean forceOverflow = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> resultHolder = BlazeExperienceBlock.applyFuel(state, level, pos, stack, forceOverflow, notConsume = player.hasInfiniteMaterials(), false);
        InteractionResult result = resultHolder.getResult();
        if (result == InteractionResult.PASS) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (result == InteractionResult.FAIL) {
            return ItemInteractionResult.FAIL;
        }
        ItemStack remainder = (ItemStack)resultHolder.getObject();
        if (!remainder.isEmpty()) {
            if (stack.isEmpty()) {
                player.setItemInHand(hand, remainder);
            } else {
                player.getInventory().placeItemBackInInventory(remainder);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static InteractionResultHolder<ItemStack> applyFuel(BlockState state, Level level, BlockPos pos, ItemStack stack, boolean forceOverflow, boolean notConsume, boolean simulate) {
        if (!state.hasBlockEntity()) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof BlazeExperienceBlockEntity)) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        BlazeExperienceBlockEntity blaze = (BlazeExperienceBlockEntity)be;
        if (stack.is((Holder)AllItems.CREATIVE_BLAZE_CAKE)) {
            blaze.applyCreativeFuel();
            if (!notConsume) {
                stack.shrink(1);
            }
            return InteractionResultHolder.success((Object)ItemStack.EMPTY);
        }
        ExperienceFuel fuel = ExperienceFuel.get(level, stack);
        if (fuel != null) {
            boolean applied = blaze.applyExperienceFuel(fuel, forceOverflow, simulate);
            if (applied) {
                if (!notConsume) {
                    stack.shrink(1);
                }
                ItemStack remainder = notConsume ? ItemStack.EMPTY : fuel.usingConvertTo().orElse(stack.getCraftingRemainingItem());
                return InteractionResultHolder.success((Object)remainder);
            }
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        return InteractionResultHolder.pass((Object)ItemStack.EMPTY);
    }
}

