/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.processing.blaze;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerRenderer;
import com.simibubi.create.content.processing.burner.BlazeBurnerVisual;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlockEntity;
import plus.dragons.createdragonsplus.util.CodeReference;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;

@FieldsNullabilityUnknownByDefault
@CodeReference(value={BlazeBurnerVisual.class}, source={"create"}, license={"mit"})
public class BlazeBlockVisual<T extends BlazeBlockEntity>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private BlazeBurnerBlock.HeatLevel heatLevel;
    private boolean active;
    private final TransformedInstance head;
    private TransformedInstance smallRods;
    private TransformedInstance largeRods;
    private ScrollInstance flame;
    private PartialModel gogglesModel;
    private TransformedInstance goggles;
    private PartialModel hatModel;
    private TransformedInstance hat;

    public BlazeBlockVisual(VisualizationContext ctx, T blockEntity, float partialTicks) {
        super(ctx, blockEntity, partialTicks);
        this.heatLevel = ((BlazeBlockEntity)((Object)blockEntity)).getHeatLevel();
        this.active = ((BlazeBlockEntity)((Object)blockEntity)).isActive();
        PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel((BlazeBurnerBlock.HeatLevel)this.heatLevel, (boolean)this.active);
        this.head = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)blazeModel)).createInstance();
        this.head.light(0xF000F0);
        this.animate(partialTicks);
    }

    protected void animate(float partialTicks) {
        float animation = ((BlazeBlockEntity)this.blockEntity).headAnimation.getValue(partialTicks) * 0.175f;
        boolean active = animation > 0.125f;
        BlazeBurnerBlock.HeatLevel heatLevel = ((BlazeBlockEntity)this.blockEntity).getHeatLevelForRender();
        if (active != this.active || heatLevel != this.heatLevel) {
            this.active = active;
            this.heatLevel = heatLevel;
            PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel((BlazeBurnerBlock.HeatLevel)heatLevel, (boolean)active);
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)blazeModel)).stealInstance((Instance)this.head);
            boolean needsRods = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            boolean hasRods = this.heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            if (needsRods && !hasRods) {
                PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
                PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
                this.smallRods = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)rodsModel)).createInstance();
                this.largeRods = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)rodsModel2)).createInstance();
                this.smallRods.light(0xF000F0);
                this.largeRods.light(0xF000F0);
            } else if (!needsRods && hasRods) {
                if (this.smallRods != null) {
                    this.smallRods.delete();
                }
                if (this.largeRods != null) {
                    this.largeRods.delete();
                }
                this.smallRods = null;
                this.largeRods = null;
            }
        }
        if (active && this.flame == null) {
            this.setupFlameInstance();
        } else if (!active && this.flame != null) {
            this.flame.delete();
            this.flame = null;
        }
        PartialModel gogglesModel = ((BlazeBlockEntity)this.blockEntity).getGogglesModel(heatLevel);
        if (this.goggles == null) {
            if (gogglesModel != null) {
                this.goggles = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)gogglesModel)).createInstance();
                this.goggles.light(0xF000F0);
            }
        } else {
            if (gogglesModel == null) {
                this.goggles.delete();
                this.goggles = null;
            } else if (this.gogglesModel != gogglesModel) {
                this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)gogglesModel)).stealInstance((Instance)this.goggles);
            }
            this.gogglesModel = gogglesModel;
        }
        PartialModel hatModel = ((BlazeBlockEntity)this.blockEntity).getHatModel(heatLevel);
        if (this.hat == null) {
            if (hatModel != null) {
                this.hat = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)hatModel)).createInstance();
                this.hat.light(0xF000F0);
            }
        } else {
            if (hatModel == null) {
                this.hat.delete();
                this.hat = null;
            } else if (this.hatModel != hatModel) {
                this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)hatModel)).stealInstance((Instance)this.hat);
            }
            this.hatModel = hatModel;
        }
        int seed = ((Object)((Object)((BlazeBlockEntity)this.blockEntity))).hashCode();
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
        float seededRenderTime = renderTime + (float)(seed % 13) * 16.0f;
        float offsetScale = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((float)(seededRenderTime / 16.0f % ((float)Math.PI * 2))) / offsetScale;
        float headY = offset - animation * 0.75f;
        float horizontalAngle = AngleHelper.rad((double)((BlazeBlockEntity)this.blockEntity).headAngle.getValue(partialTicks));
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.head.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        if (this.goggles != null && gogglesModel != null) {
            this.setupGogglesTransform(gogglesModel, this.goggles, headY, horizontalAngle);
        }
        if (this.hat != null && hatModel != null) {
            this.setupHatTransform(hatModel, this.hat, headY, horizontalAngle);
        }
        if (this.smallRods != null) {
            float offsetSmallRods = Mth.sin((float)(seededRenderTime / 16.0f + (float)Math.PI)) % ((float)Math.PI * 2) / offsetScale;
            ((TransformedInstance)((TransformedInstance)this.smallRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(offsetSmallRods + animation + 0.125f)).setChanged();
        }
        if (this.largeRods != null) {
            float offsetLargeRods = Mth.sin((float)((seededRenderTime / 16.0f + 1.5707964f) % ((float)Math.PI * 2))) / offsetScale;
            ((TransformedInstance)((TransformedInstance)this.largeRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(offsetLargeRods + animation - 0.1875f)).setChanged();
        }
    }

    protected void setupGogglesTransform(PartialModel gogglesModel, TransformedInstance goggles, float headY, float horizontalAngle) {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)goggles.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).rotateCentered(horizontalAngle, Direction.UP)).translateY(headY + 0.5f)).setChanged();
    }

    protected void setupHatTransform(PartialModel hatModel, TransformedInstance hat, float headY, float horizontalAngle) {
        ((TransformedInstance)((TransformedInstance)hat.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, headY + 0.75f, 0.5f).setChanged();
    }

    protected void setupFlameInstance() {
        this.flame = (ScrollInstance)this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME)).createInstance();
        this.flame.position((Vec3i)this.getVisualPosition()).light(0xF000F0);
        SpriteShiftEntry spriteShift = this.heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
        float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
        float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
        float speed = 0.03125f + 0.015625f * (float)this.heatLevel.ordinal();
        this.flame.speedU = speed / 2.0f;
        this.flame.speedV = speed;
        this.flame.scaleU = spriteWidth / 2.0f;
        this.flame.scaleV = spriteHeight / 2.0f;
        this.flame.diffU = spriteShift.getTarget().getU0() - spriteShift.getOriginal().getU0();
        this.flame.diffV = spriteShift.getTarget().getV0() - spriteShift.getOriginal().getV0();
    }

    public void tick(TickableVisual.Context context) {
        ((BlazeBlockEntity)this.blockEntity).tickAnimation();
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (this.isVisible(context.frustum()) && !this.doDistanceLimitThisFrame(context)) {
            this.animate(context.partialTick());
        }
    }

    protected void _delete() {
        this.head.delete();
        if (this.smallRods != null) {
            this.smallRods.delete();
        }
        if (this.largeRods != null) {
            this.largeRods.delete();
        }
        if (this.flame != null) {
            this.flame.delete();
        }
        if (this.goggles != null) {
            this.goggles.delete();
        }
        if (this.hat != null) {
            this.hat.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public void updateLight(float partialTick) {
    }
}

