/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.freezing;

import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.processing.freeze.BlockFreezer;
import plus.dragons.createdragonsplus.common.processing.freeze.FreezeCondition;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.integration.ModIntegration;

public class FreezingFanProcessingType
implements FanProcessingType {
    private final DeferredHolder<FanProcessingType, FanProcessingType> createGarnishedType = DeferredHolder.create((ResourceKey)CreateRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)ModIntegration.CREATE_GARNISHED.asResource("freezing"));
    private final DeferredHolder<RecipeType<?>, RecipeType<ProcessingRecipe<SingleRecipeInput>>> createGarnishedRecipe = DeferredHolder.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)ModIntegration.CREATE_GARNISHED.asResource("freezing"));

    public boolean isValidAt(Level level, BlockPos pos) {
        if (!((Boolean)CDPConfig.recipes().enableBulkFreezing.get()).booleanValue()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        float freeze = BlockFreezer.findFreeze(level, pos, state);
        if (freeze >= 0.0f) {
            return true;
        }
        return this.createGarnishedType.isBound() && ((FanProcessingType)this.createGarnishedType.get()).isValidAt(level, pos);
    }

    public int getPriority() {
        return 600;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        Optional recipe = level.getRecipeManager().getRecipeFor(CDPRecipes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level);
        if (recipe.isPresent()) {
            return true;
        }
        return this.canProcessByCreateGarnished(stack, level);
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return level.getRecipeManager().getRecipeFor(CDPRecipes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipe)).or(() -> this.processByCreateGarnished(stack, level)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        int color = Color.mixColors((int)FreezeCondition.PASSIVE.getColor(), (int)FreezeCondition.FROZEN.getColor(), (float)random.nextFloat());
        particleAccess.setColor(color);
        particleAccess.setAlpha(1.0f);
        if (random.nextInt(32) == 0) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity.canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksRequiredToFreeze(), entity.getTicksFrozen()) + 3);
        }
        entity.extinguishFire();
    }

    private boolean canProcessByCreateGarnished(ItemStack stack, Level level) {
        if (!this.createGarnishedRecipe.isBound()) {
            return false;
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)this.createGarnishedRecipe.get(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    private Optional<List<ItemStack>> processByCreateGarnished(ItemStack stack, Level level) {
        if (!this.createGarnishedRecipe.isBound()) {
            return Optional.empty();
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)this.createGarnishedRecipe.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipe));
    }
}

