/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientConfigHelper;
import com.mrcrayfish.configured.client.ClientSessionData;
import com.mrcrayfish.configured.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ConfigHelper {
    public static List<IConfigEntry> gatherAllConfigEntries(IConfigEntry entry) {
        ObjectArrayList entries = new ObjectArrayList();
        ArrayDeque<IConfigEntry> queue = new ArrayDeque<IConfigEntry>(entry.getChildren());
        while (!queue.isEmpty()) {
            IConfigEntry e = (IConfigEntry)queue.poll();
            entries.add(e);
            if (e.isLeaf()) continue;
            queue.addAll(e.getChildren());
        }
        return entries;
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IConfigEntry entry) {
        ObjectArrayList values = new ObjectArrayList();
        ConfigHelper.gatherValuesFromForgeConfig(entry, values);
        return ImmutableList.copyOf((Collection)values);
    }

    private static void gatherValuesFromForgeConfig(IConfigEntry entry, List<IConfigValue<?>> values) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            if (value != null) {
                values.add(value);
            }
            return;
        }
        for (IConfigEntry children : entry.getChildren()) {
            ConfigHelper.gatherValuesFromForgeConfig(children, values);
        }
    }

    public static boolean isServerConfig(IModConfig config) {
        return config.getType().isServer();
    }

    public static boolean isConfiguredInstalledOnServer() {
        if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
            return true;
        }
        return ClientConfigHelper.isConfiguredInstalledRemotely();
    }

    public static Set<IConfigValue<?>> getChangedValues(IConfigEntry entry) {
        HashSet changed = new HashSet();
        ArrayDeque<IConfigEntry> found = new ArrayDeque<IConfigEntry>();
        found.add(entry);
        while (!found.isEmpty()) {
            IConfigEntry toSave = (IConfigEntry)found.poll();
            if (!toSave.isLeaf()) {
                found.addAll(toSave.getChildren());
                continue;
            }
            IConfigValue<?> value = toSave.getValue();
            if (value == null || !value.isChanged()) continue;
            changed.add(value);
        }
        return changed;
    }

    public static boolean isPlayingGame() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return false;
        }
        return ClientConfigHelper.isPlayingGame();
    }

    public static boolean isPlayingLan() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return false;
        }
        return ClientConfigHelper.isLan() || !ConfigHelper.isIntegratedServer() && ClientSessionData.isLan();
    }

    public static boolean isSingleplayer() {
        if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
            return false;
        }
        return ClientConfigHelper.isSingleplayer();
    }

    public static boolean isServerOwnedByPlayer(@Nullable Player player) {
        if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
            return false;
        }
        return ClientConfigHelper.isServerOwnedByPlayer(player);
    }

    public static boolean isOperator(@Nullable Player player) {
        if (player != null) {
            if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
                MinecraftServer server = player.getServer();
                return server != null && server.getPlayerList().isOp(player.getGameProfile());
            }
            return player.hasPermissions(4);
        }
        return false;
    }

    public static Player getClientPlayer() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return null;
        }
        return ClientConfigHelper.getClientPlayer();
    }

    public static boolean isIntegratedServer() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return false;
        }
        return ClientConfigHelper.isIntegratedServer();
    }

    public static boolean isDeveloper(@Nullable Player player) {
        if (player != null) {
            if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
                return Config.isDeveloperEnabled() && Config.getDevelopers().contains((Object)player.getUUID());
            }
            return player.isLocalPlayer() && ClientSessionData.isDeveloper() || ConfigHelper.isServerOwnedByPlayer(player);
        }
        return false;
    }

    public static boolean isPlayingOnRemoteServer() {
        if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
            return true;
        }
        return ClientConfigHelper.isPlayingRemotely();
    }

    public static boolean canRestoreConfig(IModConfig config, Player player) {
        return config.restoreDefaultsTask().isPresent() && config.canPlayerEdit(player).asBoolean();
    }
}

