/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.sound;

import net.emilsg.clutterbestiary.entity.custom.PotionWaspEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class PotionWaspSoundInstance
extends AbstractTickableSoundInstance {
    protected final PotionWaspEntity potionWasp;

    public PotionWaspSoundInstance(PotionWaspEntity potionWasp) {
        super(ModSoundEvents.ENTITY_POTION_WASP_FLY.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.potionWasp = potionWasp;
        this.x = (float)potionWasp.getX();
        this.y = (float)potionWasp.getY();
        this.z = (float)potionWasp.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    public boolean canPlaySound() {
        return !this.potionWasp.isSilent();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (!this.potionWasp.isRemoved()) {
            this.x = (float)this.potionWasp.getX();
            this.y = (float)this.potionWasp.getY();
            this.z = (float)this.potionWasp.getZ();
            float f = (float)this.potionWasp.getDeltaMovement().horizontalDistance();
            if (f >= 0.01f) {
                this.pitch = Mth.lerp((float)Mth.clamp((float)f, (float)this.getMinPitch(), (float)this.getMaxPitch()), (float)this.getMinPitch(), (float)this.getMaxPitch());
                this.volume = Mth.lerp((float)Mth.clamp((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f);
            } else {
                this.pitch = 0.0f;
                this.volume = 0.0f;
            }
        } else {
            this.stop();
        }
    }

    private float getMaxPitch() {
        return this.potionWasp.isBaby() ? 1.5f : 1.1f;
    }

    private float getMinPitch() {
        return this.potionWasp.isBaby() ? 1.1f : 0.7f;
    }
}

