/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.ArrayList;
import net.emilsg.clutterbestiary.entity.custom.SeahorseEntity;
import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class SeahorseReleaseChildrenGoal
extends Goal {
    private final SeahorseEntity seahorse;

    public SeahorseReleaseChildrenGoal(SeahorseEntity seahorse) {
        this.seahorse = seahorse;
    }

    public boolean canUse() {
        return this.areChildrenReady();
    }

    public boolean canContinueToUse() {
        return this.areChildrenReady();
    }

    public void start() {
        Level level = this.seahorse.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            RandomSource random = serverWorld.getRandom();
            ArrayList<SeahorseEntity> children = new ArrayList<SeahorseEntity>();
            for (int i = 0; i < random.nextInt(this.seahorse.getMaxChildren()) + 1; ++i) {
                SeahorseEntity child = this.seahorse.createChild(serverWorld, this.seahorse);
                if (child == null) {
                    return;
                }
                child.setBaby(true);
                child.setPos(this.seahorse.position());
                child.setVariant(random.nextBoolean() ? this.seahorse.getVariant() : (SeahorseVariant)((Object)Util.getRandom((Object[])SeahorseVariant.values(), (RandomSource)serverWorld.random)));
                children.add(child);
            }
            for (SeahorseEntity spawnedChild : children) {
                serverWorld.addFreshEntity((Entity)spawnedChild);
            }
            this.seahorse.setHasChildren(false);
            this.seahorse.setHasChildrenTimer(0.0f);
        }
    }

    private boolean areChildrenReady() {
        return (double)this.seahorse.getHasChildrenTimer() >= 0.35;
    }
}

