/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import java.util.List;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KoiMateGoal
extends Goal {
    private static final TargetingConditions VALID_MATE_PREDICATE = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final KoiEntity koiEntity;
    protected final Level world;
    private final Class<? extends KoiEntity> entityClass;
    private final double speed;
    @Nullable
    protected KoiEntity mate;
    private int timer;

    public KoiMateGoal(KoiEntity koiEntity, double speed, Class<? extends KoiEntity> entityClass) {
        this.koiEntity = koiEntity;
        this.world = koiEntity.level();
        this.entityClass = entityClass;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.koiEntity.isInLove()) {
            return false;
        }
        this.mate = this.findMate();
        return this.mate != null;
    }

    public boolean canContinueToUse() {
        if (this.mate == null) {
            return false;
        }
        return this.mate.isAlive() && this.mate.isInLove() && this.timer < 60;
    }

    public void stop() {
        this.mate = null;
        this.timer = 0;
    }

    public void tick() {
        this.koiEntity.getLookControl().setLookAt((Entity)this.mate, 10.0f, (float)this.koiEntity.getMaxHeadXRot());
        this.koiEntity.getNavigation().moveTo((Entity)this.mate, this.speed);
        ++this.timer;
        if (this.timer >= this.adjustedTickDelay(60) && this.koiEntity.distanceToSqr((Entity)this.mate) < 9.0) {
            this.breed();
        }
    }

    protected void breed() {
        this.koiEntity.breed((ServerLevel)this.world, this.mate);
    }

    @Nullable
    private KoiEntity findMate() {
        List list = this.world.getNearbyEntities(this.entityClass, VALID_MATE_PREDICATE, (LivingEntity)this.koiEntity, this.koiEntity.getBoundingBox().inflate(8.0));
        double d = Double.MAX_VALUE;
        KoiEntity koiEntity1 = null;
        for (KoiEntity koiEntity2 : list) {
            if (!this.koiEntity.canBreedWith(koiEntity2) || !(this.koiEntity.distanceToSqr((Entity)koiEntity2) < d)) continue;
            koiEntity1 = koiEntity2;
            d = this.koiEntity.distanceToSqr((Entity)koiEntity2);
        }
        return koiEntity1;
    }
}

