/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.List;
import net.emilsg.clutterbestiary.entity.variants.PotionWaspVariant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PotionSacEntity
extends Mob {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(PotionSacEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public PotionSacEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public boolean canCollideWith(Entity other) {
        return false;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public PotionWaspVariant getVariant() {
        return PotionWaspVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(PotionWaspVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
    }

    public void tick() {
        super.tick();
        if (this.onGround() || this.horizontalCollision || this.isInWall() && this.isAlive()) {
            Level world = this.level();
            AreaEffectCloud potionCloud = (AreaEffectCloud)EntityType.AREA_EFFECT_CLOUD.create(world);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                if (potionCloud != null) {
                    potionCloud.setPotionContents(new PotionContents(this.getVariant().getPotionEffect()));
                    potionCloud.setDuration(300);
                    potionCloud.setRadius(1.5f);
                    potionCloud.setPos(this.position());
                    serverWorld.addFreshEntity((Entity)potionCloud);
                    this.kill();
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SLIME_DEATH_SMALL;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)PotionWaspVariant.REGENERATION.getId());
    }
}

