/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.emilsg.clutterbestiary.entity.custom.goal.TamedEscapeDangerGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.WanderAroundFarOftenGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.item.custom.ButterflyBottleItem;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class ChameleonEntity
extends ParentTameableEntity {
    private static final Ingredient BREEDING_INGREDIENT;
    private static final EntityDataAccessor<Boolean> SITTING;
    private static final EntityDataAccessor<Boolean> ATTACKING;
    private int currentColor = 9487484;
    private int targetColor = 9487484;
    private int retainColorChangeTimer = 0;
    private int colorTicker = 0;
    public final AnimationState tailIdleAnimationState = new AnimationState();
    public final AnimationState toungeIdleAnimationState = new AnimationState();
    public int tailIdleAnimationTimeout = 0;
    public int toungeIdleAnimationTimeout = 0;
    public final AnimationState sittingAnimationState = new AnimationState();

    private void setupAnimationStates() {
        if (this.tailIdleAnimationTimeout <= 0 && !this.isMoving()) {
            this.tailIdleAnimationTimeout = 40;
            this.tailIdleAnimationState.start(this.tickCount);
        } else {
            --this.tailIdleAnimationTimeout;
        }
        if (this.toungeIdleAnimationTimeout <= 0) {
            this.toungeIdleAnimationTimeout = 20 + (this.random.nextInt(5) + 3) * 100;
            this.toungeIdleAnimationState.start(this.tickCount);
        } else {
            --this.toungeIdleAnimationTimeout;
        }
        if (this.isOrderedToSit() && !this.sittingAnimationState.isStarted()) {
            this.sittingAnimationState.start(this.tickCount);
        } else if (!this.isOrderedToSit()) {
            this.sittingAnimationState.stop();
        }
    }

    public boolean isAggressive() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setAggressive(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public int getCurrentColor() {
        return this.currentColor;
    }

    public int getTargetColor() {
        return this.targetColor;
    }

    public void setTargetColor(int color) {
        this.targetColor = color;
    }

    public ChameleonEntity(EntityType<? extends ParentTameableEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.CHAMELEONS_SPAWN_ON);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.18f).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.ATTACK_KNOCKBACK, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f * 2.75f, 0.2f);
    }

    @Nullable
    public ChameleonEntity createChild(ServerLevel serverWorld, AgeableMob passiveEntity) {
        UUID uUID;
        ChameleonEntity chameleonEntity = (ChameleonEntity)((EntityType)ModEntityTypes.CHAMELEON.get()).create((Level)serverWorld);
        if (chameleonEntity != null && (uUID = this.getOwnerUUID()) != null) {
            chameleonEntity.setOwnerUUID(uUID);
            chameleonEntity.setTame(true, true);
        }
        return chameleonEntity;
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        super.spawnChildFromBreeding(world, other);
    }

    public boolean canMate(Animal other) {
        if (other == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(other instanceof ChameleonEntity)) {
            return false;
        }
        ChameleonEntity chameleonEntity = (ChameleonEntity)other;
        if (!chameleonEntity.isTame()) {
            return false;
        }
        if (chameleonEntity.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && chameleonEntity.isInLove();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        Item item = stackInHand.getItem();
        Item itemForTaming = Items.APPLE;
        if (this.isFood(stackInHand) && this.getHealth() < this.getMaxHealth()) {
            FoodProperties foodComponent;
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            float nutrition = (foodComponent = (FoodProperties)stackInHand.get(DataComponents.FOOD)) != null ? (float)foodComponent.nutrition() : 1.0f;
            this.heal(2.0f * nutrition);
            return InteractionResult.SUCCESS;
        }
        if (item == itemForTaming && !this.isTame()) {
            this.playSound(SoundEvents.FROG_EAT, 1.0f, 1.25f);
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            if (this.random.nextInt(3) == 0 && !this.level().isClientSide()) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setHealth(this.getMaxHealth());
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setSit(true);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.level().isClientSide() && hand == InteractionHand.MAIN_HAND && !(stackInHand.getItem() instanceof ButterflyBottleItem) && this.isOwnedBy((LivingEntity)player)) {
            this.setSit(!this.isOrderedToSit());
            return InteractionResult.SUCCESS;
        }
        if (stackInHand.getItem() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
            boolean hasNearbyEntity = !world.getEntities((Entity)this, this.getBoundingBox().inflate(6.0), entity -> entity != null && entity != this && this.getOwner() != entity && !(entity instanceof ChameleonEntity) && !entity.isShiftKeyDown()).isEmpty();
            this.setAggressive(hasNearbyEntity);
            this.updateColorTransition(hasNearbyEntity);
        }
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.getItem() instanceof ButterflyBottleItem;
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(SITTING, (Object)nbt.getBoolean("isSitting"));
    }

    public void setSit(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        super.setOrderedToSit(sitting);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(ATTACKING, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new TamedEscapeDangerGoal(this, 1.5));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(9, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(10, (Goal)new WanderAroundFarOftenGoal((PathfinderMob)this, 1.0f));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ButterflyEntity.class, true));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("isSitting", ((Boolean)this.entityData.get(SITTING)).booleanValue());
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    protected void applyTamingSideEffects() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(18.0);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
    }

    private void updateColorTransition(boolean shouldChangeColor) {
        ++this.colorTicker;
        if (this.colorTicker % 2 == 0) {
            if (shouldChangeColor) {
                this.retainColorChangeTimer = 200;
            }
            if (this.retainColorChangeTimer > 0) {
                --this.retainColorChangeTimer;
                int r1 = this.currentColor >> 16 & 0xFF;
                int g1 = this.currentColor >> 8 & 0xFF;
                int b1 = this.currentColor & 0xFF;
                int r2 = this.targetColor >> 16 & 0xFF;
                int g2 = this.targetColor >> 8 & 0xFF;
                int b2 = this.targetColor & 0xFF;
                float lerpSpeed = 0.5f;
                int r = (int)((float)r1 + (float)(r2 - r1) * lerpSpeed);
                int g = (int)((float)g1 + (float)(g2 - g1) * lerpSpeed);
                int b = (int)((float)b1 + (float)(b2 - b1) * lerpSpeed);
                this.currentColor = r << 16 | g << 8 | b;
            } else {
                this.targetColor = 9487484;
                this.currentColor = 9487484;
            }
            this.colorTicker = 0;
        }
    }

    static {
        SITTING = SynchedEntityData.defineId(ChameleonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        ATTACKING = SynchedEntityData.defineId(ChameleonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BUTTERFLY_IN_A_BOTTLE.get()});
    }
}

