/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.KiwiBirdEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.KiwiBirdEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class KiwiBirdModel<T extends KiwiBirdEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart head;

    public KiwiBirdModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("All");
        this.head = this.all.getChild("Head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition All = modelPartData.addOrReplaceChild("All", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.5f));
        PartDefinition Torso = All.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(7, 10).addBox(-2.0f, -2.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition L_Leg = All.addOrReplaceChild("L_Leg", CubeListBuilder.create().texOffs(12, 23).addBox(-0.5f, 3.01f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 20).addBox(-0.5f, 1.01f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(23, 20).addBox(-1.0f, -0.74f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)1.0f, (float)0.5f));
        PartDefinition R_Leg = All.addOrReplaceChild("R_Leg", CubeListBuilder.create().texOffs(17, 23).addBox(-0.5f, 3.01f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(13, 20).addBox(-0.5f, 1.01f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(1, 20).addBox(-1.0f, -0.74f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.0f, (float)0.5f));
        PartDefinition Head = All.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(1, 2).addBox(-1.5f, -1.5f, -2.75f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-2.0f));
        PartDefinition beak_r1 = Head.addOrReplaceChild("beak_r1", CubeListBuilder.create().texOffs(22, 4).addBox(-0.5f, -0.75f, -3.25f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-2.25f, (float)0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.75f;
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 0.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.getHeadPart().offsetScale(this.createVec3f(1.0f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(KiwiBirdEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)entity, netHeadYaw, headPitch, ageInTicks);
        if (!entity.isSongPlaying()) {
            this.animateWalk(KiwiBirdEntityAnimations.KIWI_BIRD_WALK, limbSwing, limbSwingAmount, 3.0f, 2.0f);
        }
        if (entity.isSongPlaying()) {
            this.animate(entity.dancingAnimationState, KiwiBirdEntityAnimations.KIWI_BIRD_DANCE, ageInTicks, 1.0f);
        }
        this.animate(entity.idleAnimationState, KiwiBirdEntityAnimations.KIWI_BIRD_IDLE, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

