/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.EmberTortoiseEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.EmberTortoiseEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class EmberTortoiseModel<T extends EmberTortoiseEntity>
extends BestiaryModel<T> {
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart root;

    public EmberTortoiseModel(ModelPart root) {
        this.root = root;
        this.all = this.root.getChild("all");
        this.body = this.all.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -10.0f, -12.0f, 20.0f, 4.0f, 24.0f, new CubeDeformation(0.0f)).texOffs(7, 30).addBox(-8.0f, -6.0f, -10.0f, 16.0f, 1.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(64, 41).addBox(-6.0f, -14.0f, -12.0f, 12.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shell = body.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 55).addBox(-9.0f, -3.0f, -11.0f, 18.0f, 6.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition shellTwo = shell.addOrReplaceChild("shellTwo", CubeListBuilder.create().texOffs(0, 91).addBox(-8.0f, -18.0f, -10.0f, 16.0f, 3.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition frontLeftTube = shellTwo.addOrReplaceChild("frontLeftTube", CubeListBuilder.create().texOffs(0, 67).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-18.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition frontMiddleTube = shellTwo.addOrReplaceChild("frontMiddleTube", CubeListBuilder.create().texOffs(0, 83).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-18.0f, (float)-7.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition frontRightTube = shellTwo.addOrReplaceChild("frontRightTube", CubeListBuilder.create().texOffs(0, 13).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-18.0f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition middleLeftTube = shellTwo.addOrReplaceChild("middleLeftTube", CubeListBuilder.create().texOffs(80, 64).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-18.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition middleRightTube = shellTwo.addOrReplaceChild("middleRightTube", CubeListBuilder.create().texOffs(58, 55).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-18.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition backLeftTube = shellTwo.addOrReplaceChild("backLeftTube", CubeListBuilder.create().texOffs(0, 55).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-18.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition backMiddleTube = shellTwo.addOrReplaceChild("backMiddleTube", CubeListBuilder.create().texOffs(82, 22).addBox(-3.0f, -5.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-18.0f, (float)7.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition backRightTube = shellTwo.addOrReplaceChild("backRightTube", CubeListBuilder.create().texOffs(16, 83).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-18.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition frontRightLeg = body.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(64, 28).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.25f, (float)-6.5f, (float)-9.25f));
        PartDefinition backRightLeg = body.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(0, 28).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.25f, (float)-6.5f, (float)9.25f));
        PartDefinition frontLeftLeg = body.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(74, 77).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.25f, (float)-6.5f, (float)-9.25f));
        PartDefinition backLeftLeg = body.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.25f, (float)-6.5f, (float)9.25f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)-12.0f));
        PartDefinition throat = neck.addOrReplaceChild("throat", CubeListBuilder.create().texOffs(0, 41).addBox(-3.0f, -2.5f, -2.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.4239f, (float)-1.3827f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(64, 11).addBox(-4.0f, -3.0f, -7.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-1.25f, (float)-4.0f));
        PartDefinition lowerHead = head.addOrReplaceChild("lowerHead", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, -1.0f, -7.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.head.offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(EmberTortoiseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)entity, netHeadYaw, headPitch, ageInTicks);
        if (!entity.isShielding()) {
            this.animateWalk(EmberTortoiseEntityAnimations.EMBER_TORTOISE_WALK, limbSwing, limbSwingAmount, 3.0f, 2.0f);
        }
        if (entity.isShielding()) {
            this.animate(entity.shieldingAnimationState, EmberTortoiseEntityAnimations.EMBER_TORTOISE_SHIELD, ageInTicks, 1.0f);
            this.animate(entity.shieldingTubeAnimationState, EmberTortoiseEntityAnimations.EMBER_TORTOISE_SHIELD_TUBE_LOOP, ageInTicks, 1.0f);
        }
        this.animate(entity.attackAnimationState, EmberTortoiseEntityAnimations.EMBER_TORTOISE_ATTACK, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

