/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.apache.commons.dbcp2.datasources;

import de.bluecolored.shadow.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.InstanceKeyDataSourceFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.KeyedCPDSConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.PooledConnectionManager;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.SharedPoolDataSourceFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.datasources.UserPassKey;
import de.bluecolored.shadow.apache.commons.pool2.KeyedObjectPool;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericKeyedObjectPool;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -1458539734480586454L;
    private int maxTotal = -1;
    private transient KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool;
    private transient KeyedCPDSConnectionFactory factory;

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.factory;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String userName, String userPassword) throws SQLException {
        SharedPoolDataSource sharedPoolDataSource = this;
        synchronized (sharedPoolDataSource) {
            if (this.pool == null) {
                try {
                    this.registerPool(userName, userPassword);
                }
                catch (NamingException e) {
                    throw new SQLException("registerPool failed", e);
                }
            }
        }
        try {
            return this.pool.borrowObject(new UserPassKey(userName, userPassword));
        }
        catch (Exception e) {
            throw new SQLException("Could not retrieve connection info from pool", e);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return ref;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            SharedPoolDataSource oldDS = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = oldDS.pool;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }

    private void registerPool(String userName, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(userName, password);
        this.factory = new KeyedCPDSConnectionFactory(cpds, this.getValidationQuery(), this.getValidationQueryTimeout(), this.isRollbackAfterValidation());
        this.factory.setMaxConnLifetime(this.getMaxConnLifetime());
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setBlockWhenExhausted(this.getDefaultBlockWhenExhausted());
        config.setEvictionPolicyClassName(this.getDefaultEvictionPolicyClassName());
        config.setLifo(this.getDefaultLifo());
        config.setMaxIdlePerKey(this.getDefaultMaxIdle());
        config.setMaxTotal(this.getMaxTotal());
        config.setMaxTotalPerKey(this.getDefaultMaxTotal());
        config.setMaxWaitMillis(this.getDefaultMaxWait().toMillis());
        config.setMinEvictableIdleTimeMillis(this.getDefaultMinEvictableIdleTimeMillis());
        config.setMinIdlePerKey(this.getDefaultMinIdle());
        config.setNumTestsPerEvictionRun(this.getDefaultNumTestsPerEvictionRun());
        config.setSoftMinEvictableIdleTimeMillis(this.getDefaultSoftMinEvictableIdleTimeMillis());
        config.setTestOnCreate(this.getDefaultTestOnCreate());
        config.setTestOnBorrow(this.getDefaultTestOnBorrow());
        config.setTestOnReturn(this.getDefaultTestOnReturn());
        config.setTestWhileIdle(this.getDefaultTestWhileIdle());
        config.setTimeBetweenEvictionRunsMillis(this.getDefaultTimeBetweenEvictionRunsMillis());
        GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo> tmpPool = new GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo>(this.factory, config);
        this.factory.setPool(tmpPool);
        this.pool = tmpPool;
    }

    public void setMaxTotal(int maxTotal) {
        this.assertInitializationAllowed();
        this.maxTotal = maxTotal;
    }

    @Override
    protected void setupDefaults(Connection connection, String userName) throws SQLException {
        Boolean defaultReadOnly;
        int defaultTransactionIsolation;
        Boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (defaultAutoCommit != null && connection.getAutoCommit() != defaultAutoCommit.booleanValue()) {
            connection.setAutoCommit(defaultAutoCommit);
        }
        if ((defaultTransactionIsolation = this.getDefaultTransactionIsolation()) != -1) {
            connection.setTransactionIsolation(defaultTransactionIsolation);
        }
        if ((defaultReadOnly = this.isDefaultReadOnly()) != null && connection.isReadOnly() != defaultReadOnly.booleanValue()) {
            connection.setReadOnly(defaultReadOnly);
        }
    }

    @Override
    protected void toStringFields(StringBuilder builder) {
        super.toStringFields(builder);
        builder.append(", maxTotal=");
        builder.append(this.maxTotal);
    }
}

