/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.chunk;

import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.mca.chunk.Chunk_1_13;
import de.bluecolored.bluemap.core.world.mca.chunk.Chunk_1_15;
import de.bluecolored.bluemap.core.world.mca.chunk.Chunk_1_16;
import de.bluecolored.bluemap.core.world.mca.chunk.Chunk_1_18;
import de.bluecolored.bluemap.core.world.mca.chunk.MCAChunk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class MCAChunkLoader
implements ChunkLoader<Chunk> {
    private final MCAWorld world;
    private static final List<ChunkVersionLoader<?>> CHUNK_VERSION_LOADERS = List.of(new ChunkVersionLoader<Chunk_1_18.Data>(Chunk_1_18.Data.class, Chunk_1_18::new, 2844), new ChunkVersionLoader<Chunk_1_16.Data>(Chunk_1_16.Data.class, Chunk_1_16::new, 2500), new ChunkVersionLoader<Chunk_1_13.Data>(Chunk_1_13.Data.class, Chunk_1_15::new, 2200), new ChunkVersionLoader<Chunk_1_13.Data>(Chunk_1_13.Data.class, Chunk_1_13::new, 0));
    private ChunkVersionLoader<?> lastUsedLoader = CHUNK_VERSION_LOADERS.get(0);

    public MCAChunkLoader(MCAWorld world) {
        this.world = world;
    }

    @Override
    public MCAChunk load(byte[] data, int offset, int length, Compression compression) throws IOException {
        MCAChunk chunk;
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, length);
        ((InputStream)in).mark(-1);
        ChunkVersionLoader<?> usedLoader = this.lastUsedLoader;
        try (InputStream decompressedIn = compression.decompress(in);){
            chunk = usedLoader.load(this.world, decompressedIn);
        }
        ChunkVersionLoader<?> actualLoader = this.findBestLoaderForVersion(chunk.getDataVersion());
        if (actualLoader != null && usedLoader != actualLoader) {
            ((InputStream)in).reset();
            try (InputStream decompressedIn = compression.decompress(in);){
                chunk = actualLoader.load(this.world, decompressedIn);
            }
            this.lastUsedLoader = actualLoader;
        }
        return chunk;
    }

    @Override
    public Chunk emptyChunk() {
        return Chunk.EMPTY_CHUNK;
    }

    @Override
    public Chunk erroredChunk() {
        return Chunk.ERRORED_CHUNK;
    }

    @Nullable
    private ChunkVersionLoader<?> findBestLoaderForVersion(int version) {
        for (ChunkVersionLoader<?> loader : CHUNK_VERSION_LOADERS) {
            if (!loader.mightSupport(version)) continue;
            return loader;
        }
        return null;
    }

    private static class ChunkVersionLoader<D extends MCAChunk.Data> {
        private final Class<D> dataType;
        private final BiFunction<MCAWorld, D, MCAChunk> constructor;
        private final int dataVersion;

        public MCAChunk load(MCAWorld world, InputStream in) throws IOException {
            try {
                MCAChunk.Data data = (MCAChunk.Data)MCAUtil.BLUENBT.read(in, this.dataType);
                return this.mightSupport(data.getDataVersion()) ? this.constructor.apply(world, data) : new MCAChunk(this, world, data){};
            }
            catch (Exception e) {
                throw new IOException("Failed to parse chunk-data: " + String.valueOf(e), e);
            }
        }

        public boolean mightSupport(int dataVersion) {
            return dataVersion >= this.dataVersion;
        }

        public ChunkVersionLoader(Class<D> dataType, BiFunction<MCAWorld, D, MCAChunk> constructor, int dataVersion) {
            this.dataType = dataType;
            this.constructor = constructor;
            this.dataVersion = dataVersion;
        }

        public Class<D> getDataType() {
            return this.dataType;
        }

        public BiFunction<MCAWorld, D, MCAChunk> getConstructor() {
            return this.constructor;
        }

        public int getDataVersion() {
            return this.dataVersion;
        }
    }
}

