/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql.commandset;

import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.commandset.AbstractCommandSet;
import org.intellij.lang.annotations.Language;

public class SqliteCommandSet
extends AbstractCommandSet {
    public SqliteCommandSet(Database db) {
        super(db);
    }

    @Override
    @Language(value="sqlite")
    public String createMapTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_map` (\n `id` INTEGER PRIMARY KEY AUTOINCREMENT,\n `map_id` TEXT UNIQUE NOT NULL\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String createCompressionTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_compression` (\n `id` INTEGER PRIMARY KEY AUTOINCREMENT,\n `key` TEXT UNIQUE NOT NULL\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String createItemStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_item_storage` (\n `id` INTEGER PRIMARY KEY AUTOINCREMENT,\n `key` TEXT UNIQUE NOT NULL\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String createItemStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_item_storage_data` (\n `map` INTEGER NOT NULL,\n `storage` INTEGER NOT NULL,\n `compression` INTEGER NOT NULL,\n `data` BLOB NOT NULL,\n PRIMARY KEY (`map`, `storage`),\n CONSTRAINT `fk_bluemap_item_map`\n  FOREIGN KEY (`map`)\n  REFERENCES `bluemap_map` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_item`\n  FOREIGN KEY (`storage`)\n  REFERENCES `bluemap_item_storage` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_item_compression`\n  FOREIGN KEY (`compression`)\n  REFERENCES `bluemap_compression` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String createGridStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_grid_storage` (\n `id` INTEGER PRIMARY KEY AUTOINCREMENT,\n `key` TEXT UNIQUE NOT NULL\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String createGridStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_grid_storage_data` (\n `map` INTEGER NOT NULL,\n `storage` INTEGER NOT NULL,\n `x` INTEGER NOT NULL,\n `z` INTEGER NOT NULL,\n `compression` INTEGER NOT NULL,\n `data` BLOB NOT NULL,\n PRIMARY KEY (`map`, `storage`, `x`, `z`),\n CONSTRAINT `fk_bluemap_grid_map`\n  FOREIGN KEY (`map`)\n  REFERENCES `bluemap_map` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_grid`\n  FOREIGN KEY (`storage`)\n  REFERENCES `bluemap_grid_storage` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_grid_compression`\n  FOREIGN KEY (`compression`)\n  REFERENCES `bluemap_compression` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE\n) STRICT\n";
    }

    @Override
    @Language(value="sqlite")
    public String itemStorageWriteStatement() {
        return "REPLACE\nINTO `bluemap_item_storage_data` (`map`, `storage`, `compression`, `data`)\nVALUES (?, ?, ?, ?)\n";
    }

    @Override
    @Language(value="sqlite")
    public String itemStorageReadStatement() {
        return "SELECT `data`\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String itemStorageDeleteStatement() {
        return "DELETE\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String itemStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageWriteStatement() {
        return "REPLACE\nINTO `bluemap_grid_storage_data` (`map`, `storage`, `x`, `z`, `compression`, `data`)\nVALUES (?, ?, ?, ?, ?, ?)\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageReadStatement() {
        return "SELECT `data`\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageDeleteStatement() {
        return "DELETE\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageListStatement() {
        return "SELECT `x`, `z`\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStorageCountMapItemsStatement() {
        return "SELECT COUNT(*)\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String gridStoragePurgeMapStatement() {
        return "DELETE\nFROM `bluemap_grid_storage_data`\nWHERE ROWID IN (\n SELECT t.ROWID\n FROM `bluemap_grid_storage_data` t\n WHERE t.`map` = ?\n LIMIT ?\n)\n";
    }

    @Override
    @Language(value="sqlite")
    public String purgeMapStatement() {
        return "DELETE\nFROM `bluemap_map`\nWHERE `id` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String hasMapStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_map` m\nWHERE m.`map_id` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String listMapIdsStatement() {
        return "SELECT `map_id`\nFROM `bluemap_map` m\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String findMapKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_map`\nWHERE map_id = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String createMapKeyStatement() {
        return "INSERT\nINTO `bluemap_map` (`map_id`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="sqlite")
    public String findCompressionKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_compression`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String createCompressionKeyStatement() {
        return "INSERT\nINTO `bluemap_compression` (`key`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="sqlite")
    public String findItemStorageKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_item_storage`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String createItemStorageKeyStatement() {
        return "INSERT\nINTO `bluemap_item_storage` (`key`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="sqlite")
    public String findGridStorageKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_grid_storage`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="sqlite")
    public String createGridStorageKeyStatement() {
        return "INSERT\nINTO `bluemap_grid_storage` (`key`)\nVALUES (?)\n";
    }
}

