/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.BlueMap;
import lombok.NonNull;

public class BlueMapResponseModifier
implements HttpRequestHandler {
    @NonNull
    private HttpRequestHandler delegate;
    @NonNull
    private String serverName;

    public BlueMapResponseModifier(HttpRequestHandler delegate) {
        this.delegate = delegate;
        this.serverName = "BlueMap/" + BlueMap.VERSION;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        HttpResponse response = this.delegate.handle(request);
        HttpStatusCode status = response.getStatusCode();
        if (status.getCode() >= 400 && !response.hasData()) {
            response.setData(status.getCode() + " - " + status.getMessage() + "\n" + this.serverName);
        }
        response.addHeader("Server", this.serverName);
        return response;
    }

    @NonNull
    public HttpRequestHandler getDelegate() {
        return this.delegate;
    }

    @NonNull
    public String getServerName() {
        return this.serverName;
    }

    public void setDelegate(@NonNull HttpRequestHandler delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    public void setServerName(@NonNull String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.serverName = serverName;
    }
}

