/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.nio.file.Path;

@ConfigSerializable
public class CoreConfig {
    private boolean acceptDownload = false;
    private int renderThreadCount = 1;
    private boolean metrics = true;
    private Path data = Path.of("bluemap", new String[0]);
    private boolean scanForModResources = true;
    private LogConfig log = new LogConfig();

    public boolean isAcceptDownload() {
        return this.acceptDownload;
    }

    public int getRenderThreadCount() {
        return this.renderThreadCount;
    }

    public int resolveRenderThreadCount() {
        if (this.renderThreadCount > 0) {
            return this.renderThreadCount;
        }
        return Math.max(Runtime.getRuntime().availableProcessors() + this.renderThreadCount, 1);
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public Path getData() {
        return this.data;
    }

    public boolean isScanForModResources() {
        return this.scanForModResources;
    }

    public LogConfig getLog() {
        return this.log;
    }

    @ConfigSerializable
    public static class LogConfig {
        private String file = null;
        private boolean append = false;

        public String getFile() {
            return this.file;
        }

        public boolean isAppend() {
            return this.append;
        }
    }
}

