/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class BlueMapWorldImpl
implements BlueMapWorld {
    private final String id;
    private final WeakReference<World> world;
    private final WeakReference<BlueMapService> blueMapService;
    private final WeakReference<Plugin> plugin;

    public BlueMapWorldImpl(World world, BlueMapService blueMapService, @Nullable Plugin plugin) {
        this.id = world.getId();
        this.world = new WeakReference<World>(world);
        this.blueMapService = new WeakReference<BlueMapService>(blueMapService);
        this.plugin = new WeakReference<Plugin>(plugin);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public Path getSaveFolder() {
        World world = this.unpack(this.world);
        if (world instanceof MCAWorld) {
            return ((MCAWorld)world).getDimensionFolder();
        }
        throw new UnsupportedOperationException("This world-type has no save-folder.");
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        World world = this.unpack(this.world);
        return this.unpack(this.blueMapService).getMaps().values().stream().filter(map -> map.getWorld().equals(world)).map(map -> new BlueMapMapImpl((BmMap)map, this, (Plugin)this.plugin.get())).collect(Collectors.toUnmodifiableSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueMapWorldImpl that = (BlueMapWorldImpl)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private <T> T unpack(WeakReference<T> ref) {
        return Objects.requireNonNull(ref.get(), "Reference lost to delegate object. Most likely BlueMap got reloaded and this instance is no longer valid.");
    }

    public World world() {
        return this.unpack(this.world);
    }
}

