/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.math;

import java.util.Objects;

public class Color {
    private final int r;
    private final int g;
    private final int b;
    private final float a;

    public Color(int red, int green, int blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(int red, int green, int blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    public Color(int i) {
        this(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, (float)(i >> 24 & 0xFF) / 255.0f);
    }

    public Color(int i, float alpha) {
        this(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, alpha);
    }

    public Color(int i, int alpha) {
        this(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, (float)alpha / 255.0f);
    }

    public Color(String cssColorString) {
        this(Color.parseColorString(Objects.requireNonNull(cssColorString)));
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }

    private static int parseColorString(String value) {
        Object val = value;
        if (((String)val).charAt(0) == '#') {
            if (((String)(val = ((String)val).substring(1))).length() == 3) {
                val = (String)val + "f";
            }
            if (((String)val).length() == 4) {
                val = "" + ((String)val).charAt(0) + ((String)val).charAt(0) + ((String)val).charAt(1) + ((String)val).charAt(1) + ((String)val).charAt(2) + ((String)val).charAt(2) + ((String)val).charAt(3) + ((String)val).charAt(3);
            }
            if (((String)val).length() == 6) {
                val = (String)val + "ff";
            }
            if (((String)val).length() != 8) {
                throw new NumberFormatException("Invalid color format: '" + value + "'!");
            }
            val = ((String)val).substring(6, 8) + ((String)val).substring(0, 6);
            return Integer.parseUnsignedInt((String)val, 16);
        }
        return Integer.parseInt((String)val);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        if (this.r != color.r) {
            return false;
        }
        if (this.g != color.g) {
            return false;
        }
        if (this.b != color.b) {
            return false;
        }
        return Float.compare(color.a, this.a) == 0;
    }

    public int hashCode() {
        int result = this.r;
        result = 31 * result + this.g;
        result = 31 * result + this.b;
        result = 31 * result + (this.a != 0.0f ? Float.floatToIntBits(this.a) : 0);
        return result;
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "}";
    }
}

