/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.parsers;

import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.parsers.ArgumentParser;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public abstract class SimpleArgumentParser<C, T>
implements ArgumentParser<C, T> {
    private static final Pattern QUOTED_STRING_PATTERN = Pattern.compile("\"(.*?)\"");
    private static final Pattern STRING_PATTERN = Pattern.compile("(\\S*)");
    private final boolean allowQuoted;
    private final boolean greedy;

    public SimpleArgumentParser(boolean allowQuoted, boolean greedy) {
        this.allowQuoted = allowQuoted;
        this.greedy = greedy;
    }

    @Override
    public final T parse(C context, InputReader input) throws CommandParseException {
        MatchResult result = null;
        if (this.allowQuoted) {
            result = input.read(QUOTED_STRING_PATTERN);
        }
        if (result == null && this.greedy) {
            return this.parse(context, input.readRemaining());
        }
        if (result == null) {
            result = input.read(STRING_PATTERN);
        }
        if (result == null) {
            return this.parse(context, "");
        }
        return this.parse(context, result.group(1));
    }

    public abstract T parse(C var1, String var2) throws CommandParseException;

    public boolean isAllowQuoted() {
        return this.allowQuoted;
    }

    public boolean isGreedy() {
        return this.greedy;
    }
}

