/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.MouseEventCallback;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.util.records.Pos2i;
import com.ldtteam.blockui.views.ScrollingView;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.vertex.PoseStack;

public class ScrollingContainer
extends View {
    private static final int PERCENT_90 = 90;
    private static final int PERCENT_FULL = 100;
    protected ScrollingView owner;
    protected double scrollY = 0.0;
    protected int contentHeight = 0;

    ScrollingContainer(ScrollingView owner) {
        this.owner = owner;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentHeight();
    }

    public void computeContentHeight() {
        this.contentHeight = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
        }
        this.setScrollY(this.scrollY);
    }

    public void setContentHeight(int size) {
        this.contentHeight = size;
        this.setScrollY(this.scrollY);
    }

    public int getMaxScrollY() {
        return Math.max(0, this.contentHeight - this.getHeight());
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.pose();
        this.scissorsStart(ms, this.width, this.contentHeight);
        ms.pushPose();
        ms.translate(0.0, -this.scrollY, 0.0);
        super.drawSelf(target, mx, my + this.scrollY);
        ms.popPose();
        this.scissorsEnd(target);
    }

    @Override
    public void drawSelfLast(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.pose();
        ms.pushPose();
        ms.translate(0.0, -this.scrollY, 0.0);
        super.drawSelfLast(target, mx, my + this.scrollY);
        ms.popPose();
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return child.getX() < this.getWidth() && (double)child.getY() < (double)this.getHeight() + this.scrollY && child.getX() + child.getWidth() >= 0 && (double)(child.getY() + child.getHeight()) >= this.scrollY;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public boolean setScrollY(double scroll) {
        double oldScroll = this.scrollY;
        double maxScrollY = this.getMaxScrollY();
        this.scrollY = scroll;
        if (this.scrollY > maxScrollY) {
            this.scrollY = maxScrollY;
        } else if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        return oldScroll != this.scrollY;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollPageSize() {
        return this.getHeight() * 90 / 100;
    }

    public void scrollBy(double deltaY) {
        this.setScrollY(this.scrollY + deltaY);
    }

    @Override
    protected Pos2i.MutablePos2i accumulatePosition(Pos2i.MutablePos2i accumulator) {
        if (this.parent != null) {
            this.parent.accumulatePosition(accumulator);
        }
        accumulator.x += this.x;
        accumulator.y = (int)((double)accumulator.y + ((double)this.y - this.scrollY));
        return accumulator;
    }

    @Override
    public boolean mouseEventProcessor(double mx, double my, MouseEventCallback panePredicate, MouseEventCallback eventCallbackPositive, MouseEventCallback eventCallbackNegative) {
        return super.mouseEventProcessor(mx, my + this.scrollY, panePredicate, eventCallbackPositive, eventCallbackNegative);
    }
}

