/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod.container;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.InputHandler;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.hooks.HookRegistries;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ContainerHook {
    public static TagKey<BlockEntityType<?>> CONTAINER_TAG = TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blockui", (String)"container_gui"));

    public static void init() {
    }

    public static void onContainerGuiOpen(BlockEntity thing, BOWindow window, TriggerMechanism triggerType) {
        Container container;
        Container c;
        if (!Minecraft.getInstance().hasSingleplayerServer()) {
            window.findPaneOfTypeByID("items", ScrollingList.class).off();
            window.findPaneOfTypeByID("filter", TextField.class).off();
            window.findPaneOfTypeByID("note", Text.class).setText(Component.translatable((String)"blockui.container_gui.client_side_only"));
            return;
        }
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        BlockEntity worldBlockEntity = integratedServer.getLevel(thing.getLevel().dimension()).getChunkAt(thing.getBlockPos()).getBlockEntity(thing.getBlockPos());
        Object object = worldBlockEntity instanceof Container ? (c = (Container)worldBlockEntity) : (container = worldBlockEntity.getType() == BlockEntityType.ENDER_CHEST ? integratedServer.getPlayerList().getPlayer(integratedServer.getSingleplayerProfile().getId()).getEnderChestInventory() : null);
        if (container == null) {
            HookRegistries.BLOCK_ENTITY_HOOKS.unregister(thing.getType(), triggerType);
            Log.getLogger().error("Removing container gui for type \"{}\" because it's not instance of Container class.", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)thing.getType()));
        }
        ContainerInfo containerInfo = new ContainerInfo(container);
        if (containerInfo.allItems.isEmpty()) {
            window.findPaneOfTypeByID("items", ScrollingList.class).off();
            window.findPaneOfTypeByID("filter", TextField.class).off();
            window.findPaneOfTypeByID("note", Text.class).setText(Component.translatable((String)"blockui.container_gui.empty"));
        } else {
            window.findPaneOfTypeByID("items", ScrollingList.class).setDataProvider(containerInfo);
            window.findPaneOfTypeByID("filter", TextField.class).setHandler(containerInfo);
        }
    }

    private static /* synthetic */ boolean lambda$init$0(BlockEntity thing, TriggerMechanism type) {
        return true;
    }

    private static class ContainerInfo
    implements ScrollingList.DataProvider,
    InputHandler {
        private static final int TICKS_TO_WAIT_FOR_NO_INPUT = 20;
        private final List<ItemInfo> allItems = new ArrayList<ItemInfo>();
        private int ticksLeft = -1;
        private String filter = null;
        private List<ItemInfo> filteredItems = this.allItems;

        private ContainerInfo(Container container) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack isContainer = container.getItem(i);
                if (isContainer.isEmpty()) continue;
                ItemInfo info = null;
                for (ItemInfo itemInfo : this.allItems) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)isContainer, (ItemStack)itemInfo.is)) continue;
                    info = itemInfo;
                    break;
                }
                if (info == null) {
                    this.allItems.add(new ItemInfo(new ItemStack((ItemLike)isContainer.getItem()), isContainer.getCount()));
                    continue;
                }
                info.count += isContainer.getCount();
            }
        }

        @Override
        public void onInput(TextField input) {
            String newFilter = input.getText().strip();
            if (!newFilter.equals(this.filter)) {
                this.ticksLeft = 20;
                this.filter = newFilter;
            }
        }

        @Override
        public int getElementCount() {
            if (this.ticksLeft >= 0) {
                --this.ticksLeft;
            } else if (this.filter == null || this.filter.isEmpty()) {
                this.filteredItems = this.allItems;
            } else {
                Set<String> filterSet = Set.of(this.filter.split(" "));
                this.filteredItems = this.allItems.stream().filter(info -> Set.of(info.is.getHoverName().getString().split(" ")).containsAll(filterSet) || Set.of(BuiltInRegistries.ITEM.getKey((Object)info.is.getItem()).getPath().split(" _")).containsAll(filterSet)).toList();
            }
            return this.filteredItems.size();
        }

        @Override
        public void updateElement(int index, Pane rowPane) {
            ItemInfo info = this.filteredItems.get(index);
            ItemIcon icon = rowPane.findPaneOfTypeByID("icon", ItemIcon.class);
            if (icon.getItem() != info.is) {
                icon.setItem(info.is);
                rowPane.findPaneOfTypeByID("name", Text.class).setText(info.is.getHoverName());
                rowPane.findPaneOfTypeByID("quantity", Text.class).setText(Component.literal((String)Integer.toString(info.count)));
            }
        }

        private static class ItemInfo {
            private final ItemStack is;
            private int count;

            private ItemInfo(ItemStack is, int count) {
                this.is = is;
                this.count = count;
            }
        }
    }
}

