/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.Pandarix.block.custom.FossilBaseBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CreeperFossilBlock
extends FossilBaseBlock {
    private static final Map<Direction, VoxelShape> CREEPER_SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)Block.box((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.box((double)3.5, (double)5.25, (double)5.5, (double)12.5, (double)17.25, (double)10.5), Block.box((double)3.0, (double)0.0, (double)9.5, (double)13.0, (double)6.5, (double)14.5), Block.box((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)6.5, (double)6.5)}), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)Block.box((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.box((double)3.5, (double)5.25, (double)5.5, (double)12.5, (double)17.25, (double)10.5), Block.box((double)3.0, (double)0.0, (double)9.5, (double)13.0, (double)6.5, (double)14.5), Block.box((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)6.5, (double)6.5)}), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)Block.box((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)5.25, (double)3.5, (double)10.5, (double)17.25, (double)12.5), Block.box((double)1.5, (double)0.0, (double)3.0, (double)6.5, (double)6.5, (double)13.0), Block.box((double)9.5, (double)0.0, (double)3.0, (double)14.5, (double)6.5, (double)13.0)}), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)Block.box((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.box((double)5.5, (double)5.25, (double)3.5, (double)10.5, (double)17.25, (double)12.5), Block.box((double)1.5, (double)0.0, (double)3.0, (double)6.5, (double)6.5, (double)13.0), Block.box((double)9.5, (double)0.0, (double)3.0, (double)14.5, (double)6.5, (double)13.0)}));

    public CreeperFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(blockState, level, pos, random);
        SimpleParticleType particle = random.nextBoolean() ? ParticleTypes.SMALL_FLAME : ParticleTypes.SMOKE;
        Vec3 center = pos.getCenter();
        if (level.isClientSide()) {
            level.addParticle((ParticleOptions)particle, center.x() + (double)(random.nextFloat() * (float)CreeperFossilBlock.getRandomSign(random)), center.y() + (double)(random.nextFloat() * (float)CreeperFossilBlock.getRandomSign(random)), center.z() + (double)(random.nextFloat() * (float)CreeperFossilBlock.getRandomSign(random)), (double)(random.nextFloat() / 50.0f * (float)CreeperFossilBlock.getRandomSign(random)), (double)(random.nextFloat() / 30.0f), (double)(random.nextFloat() / 50.0f * (float)CreeperFossilBlock.getRandomSign(random)));
        }
    }

    private static int getRandomSign(RandomSource rand) {
        return rand.nextBoolean() ? 1 : -1;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return CREEPER_SHAPES_FOR_DIRECTION.get(blockState.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> component, TooltipFlag flag) {
        component.add((Component)Component.translatable((String)"block.betterarcheology.creeper_fossil_tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, component, flag);
    }
}

