/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sharks.entity;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.sharks.entity.AxodileEntity;
import net.mcreator.sharks.entity.BlacktipReefSharkEntity;
import net.mcreator.sharks.entity.BlueSharkEntity;
import net.mcreator.sharks.entity.BullSharkEntity;
import net.mcreator.sharks.entity.CookiecutterSharkEntity;
import net.mcreator.sharks.entity.LemonSharkEntity;
import net.mcreator.sharks.entity.MakoSharkEntity;
import net.mcreator.sharks.entity.MegalodonEntity;
import net.mcreator.sharks.entity.RemoraEntity;
import net.mcreator.sharks.entity.ShrakEntity;
import net.mcreator.sharks.entity.TigerSharkEntity;
import net.mcreator.sharks.init.BenssharksModEntities;
import net.mcreator.sharks.procedures.BonnetheadSharkEntityIsHurtProcedure;
import net.mcreator.sharks.procedures.BonnetheadSharkOnEntityTickUpdateProcedure;
import net.mcreator.sharks.procedures.BonnetheadSharkOnInitialEntitySpawnProcedure;
import net.mcreator.sharks.procedures.BonnetheadSharkRightClickedOnEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BonnetheadSharkEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_health = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_nametag = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_oxygen = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_uuid = SynchedEntityData.defineId(BonnetheadSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public BonnetheadSharkEntity(EntityType<BonnetheadSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (BonnetheadSharkEntity.this.isInWater()) {
                    BonnetheadSharkEntity.this.setDeltaMovement(BonnetheadSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !BonnetheadSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - BonnetheadSharkEntity.this.getX();
                    double dy = this.wantedY - BonnetheadSharkEntity.this.getY();
                    double dz = this.wantedZ - BonnetheadSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * BonnetheadSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    BonnetheadSharkEntity.this.setYRot(this.rotlerp(BonnetheadSharkEntity.this.getYRot(), f, 10.0f));
                    BonnetheadSharkEntity.this.yBodyRot = BonnetheadSharkEntity.this.getYRot();
                    BonnetheadSharkEntity.this.yHeadRot = BonnetheadSharkEntity.this.getYRot();
                    if (BonnetheadSharkEntity.this.isInWater()) {
                        BonnetheadSharkEntity.this.setSpeed((float)BonnetheadSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        BonnetheadSharkEntity.this.setXRot(this.rotlerp(BonnetheadSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(BonnetheadSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        BonnetheadSharkEntity.this.setZza(f3 * f1);
                        BonnetheadSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        BonnetheadSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    BonnetheadSharkEntity.this.setSpeed(0.0f);
                    BonnetheadSharkEntity.this.setYya(0.0f);
                    BonnetheadSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"bonnet");
        builder.define(DATA_health, (Object)8);
        builder.define(DATA_nametag, (Object)"");
        builder.define(DATA_oxygen, (Object)0);
        builder.define(DATA_uuid, (Object)"");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 15.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, CookiecutterSharkEntity.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Frog.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Tadpole.class, true, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true, true));
        this.goalSelector.addGoal(12, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(13, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SEAGRASS.asItem()}), false));
        this.goalSelector.addGoal(14, (Goal)new RemoveBlockGoal(Blocks.TALL_SEAGRASS, (PathfinderMob)this, 1.0, 32));
        this.goalSelector.addGoal(16, (Goal)new LookAtPlayerGoal((Mob)this, BlacktipReefSharkEntity.class, 8.0f));
        this.goalSelector.addGoal(17, (Goal)new LookAtPlayerGoal((Mob)this, WaterAnimal.class, 32.0f));
        this.goalSelector.addGoal(18, (Goal)new AvoidEntityGoal((PathfinderMob)this, MegalodonEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(19, (Goal)new AvoidEntityGoal((PathfinderMob)this, ElderGuardian.class, 64.0f, 16.0, 16.0));
        this.goalSelector.addGoal(20, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 64.0f, 16.0, 16.0));
        this.goalSelector.addGoal(21, (Goal)new AvoidEntityGoal((PathfinderMob)this, ShrakEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(22, (Goal)new AvoidEntityGoal((PathfinderMob)this, TigerSharkEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(23, (Goal)new AvoidEntityGoal((PathfinderMob)this, MakoSharkEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(24, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlueSharkEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(25, (Goal)new AvoidEntityGoal((PathfinderMob)this, BullSharkEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(26, (Goal)new AvoidEntityGoal((PathfinderMob)this, LemonSharkEntity.class, 4.0f, 16.0, 16.0));
        this.goalSelector.addGoal(27, (Goal)new AvoidEntityGoal((PathfinderMob)this, AxodileEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(28, (Goal)new AvoidEntityGoal((PathfinderMob)this, Dolphin.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(29, (Goal)new AvoidEntityGoal((PathfinderMob)this, RemoraEntity.class, 16.0f, 16.0, 16.0));
        this.goalSelector.addGoal(30, (Goal)new AvoidEntityGoal((PathfinderMob)this, WaterAnimal.class, 16.0f, 1.0, 1.0));
        this.goalSelector.addGoal(31, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, 0.5, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        BonnetheadSharkEntityIsHurtProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        return super.hurt(source, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        BonnetheadSharkOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putInt("Datahealth", ((Integer)this.entityData.get(DATA_health)).intValue());
        compound.putString("Datanametag", (String)this.entityData.get(DATA_nametag));
        compound.putInt("Dataoxygen", ((Integer)this.entityData.get(DATA_oxygen)).intValue());
        compound.putString("Datauuid", (String)this.entityData.get(DATA_uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datahealth")) {
            this.entityData.set(DATA_health, (Object)compound.getInt("Datahealth"));
        }
        if (compound.contains("Datanametag")) {
            this.entityData.set(DATA_nametag, (Object)compound.getString("Datanametag"));
        }
        if (compound.contains("Dataoxygen")) {
            this.entityData.set(DATA_oxygen, (Object)compound.getInt("Dataoxygen"));
        }
        if (compound.contains("Datauuid")) {
            this.entityData.set(DATA_uuid, (Object)compound.getString("Datauuid"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        BonnetheadSharkEntity entity = this;
        Level world = this.level();
        BonnetheadSharkRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        BonnetheadSharkOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.8f);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        BonnetheadSharkEntity retval = (BonnetheadSharkEntity)((EntityType)BenssharksModEntities.BONNETHEAD_SHARK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return List.of(Blocks.SEAGRASS.asItem()).contains(stack.getItem());
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)BenssharksModEntities.BONNETHEAD_SHARK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.25);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.25);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isInWaterOrBubble()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("sprint2"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("land"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("bite"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 2, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 2, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 2, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

