/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sharks.entity;

import javax.annotation.Nullable;
import net.mcreator.sharks.entity.AxodileEntity;
import net.mcreator.sharks.entity.BaskingSharkEntity;
import net.mcreator.sharks.entity.BlacktipReefSharkEntity;
import net.mcreator.sharks.entity.BlueSharkEntity;
import net.mcreator.sharks.entity.BonnetheadSharkEntity;
import net.mcreator.sharks.entity.BullSharkEntity;
import net.mcreator.sharks.entity.CookiecutterSharkEntity;
import net.mcreator.sharks.entity.GreaterAxodileEntity;
import net.mcreator.sharks.entity.GreenlandSharkEntity;
import net.mcreator.sharks.entity.LandSharkEntity;
import net.mcreator.sharks.entity.LemonSharkEntity;
import net.mcreator.sharks.entity.MakoSharkEntity;
import net.mcreator.sharks.entity.MegalodonEntity;
import net.mcreator.sharks.entity.NurseSharkEntity;
import net.mcreator.sharks.entity.PilotFishEntity;
import net.mcreator.sharks.entity.RemoraEntity;
import net.mcreator.sharks.entity.ShrakEntity;
import net.mcreator.sharks.entity.TigerSharkEntity;
import net.mcreator.sharks.entity.WhaleSharkEntity;
import net.mcreator.sharks.entity.WhitetipSharkEntity;
import net.mcreator.sharks.init.BenssharksModEntities;
import net.mcreator.sharks.init.BenssharksModItems;
import net.mcreator.sharks.procedures.BarracudaEntityIsHurtProcedure;
import net.mcreator.sharks.procedures.BarracudaOnEntityTickUpdateProcedure;
import net.mcreator.sharks.procedures.BarracudaOnInitialEntitySpawnProcedure;
import net.mcreator.sharks.procedures.BarracudaRightClickedOnEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BarracudaEntity
extends PathfinderMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(BarracudaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(BarracudaEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(BarracudaEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public BarracudaEntity(EntityType<BarracudaEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (BarracudaEntity.this.isInWater()) {
                    BarracudaEntity.this.setDeltaMovement(BarracudaEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !BarracudaEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - BarracudaEntity.this.getX();
                    double dy = this.wantedY - BarracudaEntity.this.getY();
                    double dz = this.wantedZ - BarracudaEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * BarracudaEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    BarracudaEntity.this.setYRot(this.rotlerp(BarracudaEntity.this.getYRot(), f, 10.0f));
                    BarracudaEntity.this.yBodyRot = BarracudaEntity.this.getYRot();
                    BarracudaEntity.this.yHeadRot = BarracudaEntity.this.getYRot();
                    if (BarracudaEntity.this.isInWater()) {
                        BarracudaEntity.this.setSpeed((float)BarracudaEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        BarracudaEntity.this.setXRot(this.rotlerp(BarracudaEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(BarracudaEntity.this.getXRot() * ((float)Math.PI / 180)));
                        BarracudaEntity.this.setZza(f3 * f1);
                        BarracudaEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        BarracudaEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    BarracudaEntity.this.setSpeed(0.0f);
                    BarracudaEntity.this.setYya(0.0f);
                    BarracudaEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"barracuda");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, MakoSharkEntity.class, 16.0f, 1.0, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, CookiecutterSharkEntity.class, true, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, RemoraEntity.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, true, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, PilotFishEntity.class, true, true));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, true, true));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, Pufferfish.class, true, true));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, true, true));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true, true));
        this.goalSelector.addGoal(16, (Goal)new AvoidEntityGoal((PathfinderMob)this, AxodileEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(17, (Goal)new AvoidEntityGoal((PathfinderMob)this, BaskingSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(18, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlacktipReefSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(19, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlueSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(20, (Goal)new AvoidEntityGoal((PathfinderMob)this, BonnetheadSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(21, (Goal)new AvoidEntityGoal((PathfinderMob)this, BullSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(22, (Goal)new AvoidEntityGoal((PathfinderMob)this, GreaterAxodileEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(23, (Goal)new AvoidEntityGoal((PathfinderMob)this, GreenlandSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(24, (Goal)new AvoidEntityGoal((PathfinderMob)this, LandSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(25, (Goal)new AvoidEntityGoal((PathfinderMob)this, LemonSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(26, (Goal)new AvoidEntityGoal((PathfinderMob)this, MegalodonEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(27, (Goal)new AvoidEntityGoal((PathfinderMob)this, NurseSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(28, (Goal)new AvoidEntityGoal((PathfinderMob)this, ShrakEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(29, (Goal)new AvoidEntityGoal((PathfinderMob)this, TigerSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(30, (Goal)new AvoidEntityGoal((PathfinderMob)this, WhaleSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(31, (Goal)new AvoidEntityGoal((PathfinderMob)this, WhitetipSharkEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(32, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)BenssharksModItems.RAW_BARRACUDA.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.tropical_fish.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        BarracudaEntityIsHurtProcedure.execute();
        Entity immediatesourceentity = source.getDirectEntity();
        return super.hurt(source, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        BarracudaOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        BarracudaEntity entity = this;
        Level world = this.level();
        BarracudaRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        BarracudaOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.2f);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)BenssharksModEntities.BARRACUDA.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.25);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.25);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("swim"));
            }
            if (this.isInWaterOrBubble()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("sprint"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("land"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("bite"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

