/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.storage.loot.LootTable;

public class CampsiteFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockStateProvider UNLIT_CAMPFIRES = SimpleStateProvider.simple((BlockState)((BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false))));
    private static final BlockStateProvider LIT_CAMPFIRES = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true))), 9).add((Object)((BlockState)Blocks.SOUL_CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true))), 1));
    private static final BlockStateProvider DECORATIONS = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.POTTED_DEAD_BUSH.defaultBlockState(), 2).add((Object)Blocks.POTTED_BAMBOO.defaultBlockState(), 2).add((Object)Blocks.POTTED_RED_TULIP.defaultBlockState(), 2).add((Object)Blocks.BREWING_STAND.defaultBlockState(), 1).add((Object)((BlockState)Blocks.CANDLE_CAKE.defaultBlockState().setValue((Property)CandleCakeBlock.LIT, (Comparable)Boolean.valueOf(true))), 1));
    private static final BlockStateProvider CRAFTING_STATIONS = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.CRAFTING_TABLE.defaultBlockState(), 5).add((Object)Blocks.SMITHING_TABLE.defaultBlockState(), 5).add((Object)Blocks.FLETCHING_TABLE.defaultBlockState(), 5).add((Object)Blocks.CARTOGRAPHY_TABLE.defaultBlockState(), 5).add((Object)Blocks.ANVIL.defaultBlockState(), 2).add((Object)Blocks.CHIPPED_ANVIL.defaultBlockState(), 2).add((Object)Blocks.DAMAGED_ANVIL.defaultBlockState(), 1));
    private static final BlockStateProvider FURNACES = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.FURNACE.defaultBlockState().setValue((Property)FurnaceBlock.LIT, (Comparable)Boolean.valueOf(false))), 2).add((Object)((BlockState)Blocks.BLAST_FURNACE.defaultBlockState().setValue((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false))), 1).add((Object)((BlockState)Blocks.SMOKER.defaultBlockState().setValue((Property)SmokerBlock.LIT, (Comparable)Boolean.valueOf(false))), 1));
    private static final BlockStateProvider FURNACE_CHIMNEYS = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.COBBLESTONE_WALL.defaultBlockState(), 2).add((Object)Blocks.COBBLED_DEEPSLATE_WALL.defaultBlockState(), 2).add((Object)Blocks.STONE_BRICK_WALL.defaultBlockState(), 1).add((Object)Blocks.DEEPSLATE_BRICK_WALL.defaultBlockState(), 1));
    private static final BlockStateProvider BEDS = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.RED_BED.defaultBlockState(), 1).add((Object)Blocks.YELLOW_BED.defaultBlockState(), 1).add((Object)Blocks.CYAN_BED.defaultBlockState(), 1).add((Object)Blocks.GRAY_BED.defaultBlockState(), 1).add((Object)Blocks.MAGENTA_BED.defaultBlockState(), 1).add((Object)Blocks.GREEN_BED.defaultBlockState(), 1));
    private static final BlockStateProvider LIGHT_SOURCES = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.LANTERN.defaultBlockState(), 4).add((Object)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), 1).add((Object)Blocks.SOUL_LANTERN.defaultBlockState(), 1));
    private static final BlockStateProvider UNLIT_LIGHT_SOURCES = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), 1).add((Object)((BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), 1));
    public static final ResourceKey<LootTable> CHEST_LOOT = Artifacts.key(Registries.LOOT_TABLE, "chests/campsite_chest");
    public static final ResourceKey<LootTable> BARREL_LOOT = Artifacts.key(Registries.LOOT_TABLE, "chests/campsite_barrel");

    public CampsiteFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        if (!this.isSufficientlyFlat(level, origin)) {
            return false;
        }
        BlockPos.betweenClosedStream((BlockPos)origin.offset(-2, 0, -2), (BlockPos)origin.offset(2, 2, 2)).filter(pos -> Math.abs(pos.getX() - origin.getX()) < 2 || Math.abs(pos.getZ() - origin.getZ()) < 2).filter(pos -> !level.getBlockState(pos).isAir()).forEach(pos -> this.setBlock((LevelWriter)level, (BlockPos)pos, Blocks.CAVE_AIR.defaultBlockState()));
        this.placeFloor(level, origin, random);
        this.placeCampfire(level, origin, random);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos pos2 = origin.relative(direction, 2);
        if (random.nextInt(3) == 0) {
            BlockPos.betweenClosedStream((BlockPos)pos2.relative(direction.getClockWise()), (BlockPos)pos2.relative(direction.getCounterClockWise())).forEach(barrelPos -> {
                this.placeBarrel(level, (BlockPos)barrelPos, random);
                if (random.nextInt(3) == 0) {
                    this.placeBarrel(level, barrelPos.above(), random);
                }
            });
        } else {
            Direction bedDirection = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
            BlockState bedBlock = (BlockState)BEDS.getState(random, pos2).setValue((Property)BedBlock.FACING, (Comparable)bedDirection);
            this.setBlock((LevelWriter)level, pos2, (BlockState)bedBlock.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD));
            this.setBlock((LevelWriter)level, pos2.relative(bedDirection.getOpposite()), (BlockState)bedBlock.setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT));
            this.placeBarrel(level, pos2.relative(bedDirection), random);
            this.placeLightSource(level, pos2.relative(bedDirection).above(), random);
        }
        direction = random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
        pos2 = origin.relative(direction, 2);
        List positions = BlockPos.betweenClosedStream((BlockPos)pos2.relative(direction.getClockWise()), (BlockPos)pos2.relative(direction.getCounterClockWise())).map(BlockPos::immutable).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(positions);
        this.placeCraftingStation(level, (BlockPos)positions.removeFirst(), random, direction.getOpposite());
        this.placeFurnace(level, (BlockPos)positions.removeFirst(), random, direction.getOpposite());
        this.placeChest(level, (BlockPos)positions.removeFirst(), random, direction.getOpposite());
        return true;
    }

    private boolean isSufficientlyFlat(WorldGenLevel level, BlockPos origin) {
        return BlockPos.betweenClosedStream((BlockPos)origin.offset(-2, 0, -2), (BlockPos)origin.offset(2, 0, 2)).filter(pos -> level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)).filter(pos -> level.getBlockState(pos).isAir()).count() >= 6L;
    }

    private void placeFloor(WorldGenLevel level, BlockPos origin, RandomSource random) {
        BlockPos.betweenClosedStream((BlockPos)origin.offset(-2, -1, -2), (BlockPos)origin.offset(2, -1, 2)).filter(pos -> Math.abs(pos.getX() - origin.getX()) < 2 || Math.abs(pos.getZ() - origin.getZ()) < 2).forEach(pos -> {
            if (!level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
                this.setBlock((LevelWriter)level, (BlockPos)pos, Blocks.OAK_PLANKS.defaultBlockState());
            } else if (random.nextBoolean()) {
                if (level.getBlockState(pos).is(Blocks.DEEPSLATE)) {
                    this.setBlock((LevelWriter)level, (BlockPos)pos, Blocks.COBBLED_DEEPSLATE.defaultBlockState());
                } else if (level.getBlockState(pos).is(Blocks.STONE)) {
                    this.setBlock((LevelWriter)level, (BlockPos)pos, Blocks.COBBLESTONE.defaultBlockState());
                }
            }
        });
    }

    private void placeCampfire(WorldGenLevel level, BlockPos origin, RandomSource random) {
        BlockState campfire = UNLIT_CAMPFIRES.getState(random, origin);
        if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.nextFloat() < 0.1) {
            campfire = LIT_CAMPFIRES.getState(random, origin);
        }
        this.setBlock((LevelWriter)level, origin, campfire);
    }

    private void placeLightSource(WorldGenLevel level, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() < 0.5) {
            BlockState lightSource = UNLIT_LIGHT_SOURCES.getState(random, pos);
            if (Artifacts.CONFIG.general.campsite.allowLightSources.get().booleanValue() && (double)random.nextFloat() < 0.3) {
                lightSource = LIGHT_SOURCES.getState(random, pos);
            }
            this.setBlock((LevelWriter)level, pos, lightSource);
        }
    }

    private void placeCraftingStation(WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        BlockState craftingStation = CRAFTING_STATIONS.getState(random, pos);
        if (craftingStation.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            craftingStation = (BlockState)craftingStation.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        }
        this.setBlock((LevelWriter)level, pos, craftingStation);
        if (random.nextInt(3) == 0) {
            this.setBlock((LevelWriter)level, pos.above(), DECORATIONS.getState(random, pos));
        }
    }

    private void placeFurnace(WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        BlockState furnace = FURNACES.getState(random, pos);
        furnace = (BlockState)furnace.setValue((Property)FurnaceBlock.FACING, (Comparable)facing);
        this.setBlock((LevelWriter)level, pos, furnace);
        if (random.nextBoolean()) {
            this.setBlock((LevelWriter)level, pos.above(), FURNACE_CHIMNEYS.getState(random, pos));
        }
    }

    private void placeBarrel(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockState barrel = Blocks.BARREL.defaultBlockState();
        barrel = random.nextBoolean() ? (BlockState)barrel.setValue((Property)BarrelBlock.FACING, (Comparable)Direction.UP) : (BlockState)barrel.setValue((Property)BarrelBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random));
        this.setBlock((LevelWriter)level, pos, barrel);
        RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)pos, BARREL_LOOT);
    }

    public void placeChest(WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        if ((double)random.nextFloat() < Artifacts.CONFIG.general.campsite.mimicChance.get()) {
            MimicEntity mimic = (MimicEntity)((EntityType)ModEntityTypes.MIMIC.value()).create((Level)level.getLevel());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)mimic);
            }
        } else {
            BlockState chest;
            if (random.nextInt(8) == 0) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.TNT.defaultBlockState());
                chest = Blocks.TRAPPED_CHEST.defaultBlockState();
                this.setBlock((LevelWriter)level, pos, (BlockState)Blocks.TRAPPED_CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random)));
            } else {
                chest = Artifacts.CONFIG.general.campsite.useModdedChests.get() != false ? ModTags.getTag(ModTags.CAMPSITE_CHESTS).getRandomElement(random).map(Holder::value).orElse(Blocks.CHEST).defaultBlockState() : Blocks.CHEST.defaultBlockState();
            }
            if (chest.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                chest = (BlockState)chest.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            }
            this.setBlock((LevelWriter)level, pos, chest);
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)pos, CHEST_LOOT);
        }
    }
}

