/*
 * Decompiled with CFR 0.152.
 */
package artifacts.util;

import artifacts.ability.ArtifactAbility;
import artifacts.component.AbilityToggles;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModDataComponents;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class AbilityHelper {
    public static <A extends ArtifactAbility, T> T reduce(ArtifactAbility.Type<A> type, LivingEntity entity, boolean skipItemsOnCooldown, T init, BiFunction<A, T, T> f) {
        return (T)PlatformServices.platformHelper.reduceItems(entity, init, (stack, init_) -> {
            for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                if (ability.getType() != type || skipItemsOnCooldown && AbilityHelper.isOnCooldown(entity, stack)) continue;
                init_ = f.apply(ability, init_);
            }
            return init_;
        });
    }

    private static boolean isOnCooldown(LivingEntity entity, ItemStack stack) {
        Player player;
        return !(entity instanceof Player) || (player = (Player)entity).getCooldowns().isOnCooldown(stack.getItem());
    }

    public static boolean hasAbility(ArtifactAbility.Type<?> type, ItemStack stack) {
        return AbilityHelper.hasAbility(type, stack, ability -> true);
    }

    public static <T extends ArtifactAbility> boolean hasAbility(ArtifactAbility.Type<T> type, ItemStack stack, Predicate<T> predicate) {
        for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
            if (ability.getType() != type || !ability.isEnabled() || !predicate.test(ability)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToggledOn(ArtifactAbility.Type<?> type, LivingEntity entity) {
        AbilityToggles abilityToggles = PlatformServices.platformHelper.getAbilityToggles(entity);
        if (abilityToggles != null) {
            return abilityToggles.isToggledOn(type);
        }
        return true;
    }

    public static boolean hasAbilityActive(ArtifactAbility.Type<?> type, @Nullable LivingEntity entity) {
        return AbilityHelper.hasAbilityActive(type, entity, false);
    }

    public static boolean hasAbilityActive(ArtifactAbility.Type<?> type, @Nullable LivingEntity entity, boolean skipItemsOnCooldown) {
        return AbilityHelper.hasAbilityActive(type, entity, skipItemsOnCooldown, ability -> true);
    }

    public static <A extends ArtifactAbility> boolean hasAbilityActive(ArtifactAbility.Type<A> type, @Nullable LivingEntity entity, Predicate<A> predicate) {
        return AbilityHelper.hasAbilityActive(type, entity, false, predicate);
    }

    public static <A extends ArtifactAbility> boolean hasAbilityActive(ArtifactAbility.Type<A> type, @Nullable LivingEntity entity, boolean skipItemsOnCooldown, Predicate<A> predicate) {
        if (entity == null || !AbilityHelper.isToggledOn(type, entity)) {
            return false;
        }
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, false, (ability, b) -> b != false || ability.isEnabled() && predicate.test(ability));
    }

    public static List<ArtifactAbility> getAbilities(ItemStack stack) {
        if (stack.has((DataComponentType)ModDataComponents.ABILITIES.value())) {
            return (List)stack.get((DataComponentType)ModDataComponents.ABILITIES.value());
        }
        return List.of();
    }

    public static <T extends ArtifactAbility> Stream<T> getAbilities(ArtifactAbility.Type<T> type, ItemStack stack) {
        return AbilityHelper.getAbilities(stack).stream().filter(ability -> ability.getType() == type).filter(ArtifactAbility::isEnabled).map(ability -> ability);
    }

    public static boolean isCosmetic(ItemStack stack) {
        for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
            if (!ability.isNonCosmetic()) continue;
            return false;
        }
        return true;
    }

    public static int getEnchantmentSum(ResourceKey<Enchantment> enchantment, LivingEntity entity) {
        return AbilityHelper.sumInt((ArtifactAbility.Type)ModAbilities.INCREASE_ENCHANTMENT_LEVEL.value(), entity, ability -> ability.enchantment().equals((Object)enchantment) ? ability.getAmount() : 0, false);
    }

    public static <A extends ArtifactAbility> int sumInt(ArtifactAbility.Type<A> type, LivingEntity entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0, (ability, i) -> i + (Integer)f.apply(ability));
    }

    public static <A extends ArtifactAbility> double maxDouble(ArtifactAbility.Type<A> type, LivingEntity entity, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0.0, (ability, d) -> Math.max(d, (Double)f.apply(ability)));
    }

    public static <A extends ArtifactAbility> int maxInt(ArtifactAbility.Type<A> type, LivingEntity entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, 0, (ability, d) -> Math.max(d, (Integer)f.apply(ability)));
    }

    public static <A extends ArtifactAbility> int minInt(ArtifactAbility.Type<A> type, LivingEntity entity, int init, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return AbilityHelper.reduce(type, entity, skipItemsOnCooldown, init, (ability, d) -> Math.min(d, (Integer)f.apply(ability)));
    }

    public static void addCooldown(ArtifactAbility.Type<?> type, LivingEntity entity, int ticks) {
        if (ticks > 0 && !entity.level().isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> AbilityHelper.hasAbility(type, stack)).forEach(stack -> player.getCooldowns().addCooldown(stack.getItem(), ticks));
        }
    }

    public static <A extends ArtifactAbility> void applyCooldowns(ArtifactAbility.Type<A> type, LivingEntity entity, Function<A, Integer> cooldown) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide()) {
            AbilityHelper.forEach(type, entity, (ability, stack) -> {
                int c = (Integer)cooldown.apply(ability) * 20;
                if (c > 0) {
                    player.getCooldowns().addCooldown(stack.getItem(), c);
                }
            }, true);
        }
    }

    public static <A extends ArtifactAbility> void forEach(ArtifactAbility.Type<A> type, LivingEntity entity, Consumer<A> consumer) {
        AbilityHelper.forEach(type, entity, (ability, stack) -> consumer.accept(ability), false);
    }

    public static <A extends ArtifactAbility> void forEach(ArtifactAbility.Type<A> type, LivingEntity entity, BiConsumer<A, ItemStack> consumer, boolean skipItemsOnCooldown) {
        PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> AbilityHelper.hasAbility(type, stack)).forEach(stack -> AbilityHelper.getAbilities(type, stack).filter(ArtifactAbility::isEnabled).filter(ability -> {
            Player player;
            return !skipItemsOnCooldown || !(entity instanceof Player) || !(player = (Player)entity).getCooldowns().isOnCooldown(stack.getItem());
        }).forEach(ability -> consumer.accept((Object)ability, (ItemStack)stack)));
    }
}

