/*
 * Decompiled with CFR 0.152.
 */
package artifacts.platform;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.AbilityToggles;
import artifacts.component.SwimData;
import artifacts.item.WearableArtifactItem;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface PlatformHelper {
    public Stream<ItemStack> findAllEquippedBy(LivingEntity var1, Predicate<ItemStack> var2);

    public void iterateEquippedItems(LivingEntity var1, Consumer<ItemStack> var2);

    public <T> T reduceItems(LivingEntity var1, T var2, BiFunction<ItemStack, T, T> var3);

    public boolean tryEquipInFirstSlot(LivingEntity var1, ItemStack var2);

    @Nullable
    public AbilityToggles getAbilityToggles(LivingEntity var1);

    @Nullable
    public SwimData getSwimData(LivingEntity var1);

    public Holder<Attribute> getSwimSpeedAttribute();

    public Holder<Attribute> registerAttribute(String var1, Supplier<? extends Attribute> var2);

    public void processWearableArtifactBuilder(WearableArtifactItem.Builder var1);

    public void registerAdditionalDataComponents();

    public void addCosmeticToggleTooltip(List<MutableComponent> var1, ItemStack var2);

    public boolean isEyeInWater(Player var1);

    public boolean isVisibleOnHand(LivingEntity var1, InteractionHand var2, Item var3);

    public boolean areBootsHidden(LivingEntity var1);

    public boolean isFishingRod(ItemStack var1);

    public void registerArtifactRenderer(Item var1, Supplier<ArtifactRenderer> var2);

    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item var1);

    public Path getConfigDir();
}

