/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.DoubleJumpAbility;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record DoubleJumpPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DoubleJumpPacket> TYPE = new CustomPacketPayload.Type(Artifacts.id("double_jump"));
    public static final StreamCodec<FriendlyByteBuf, DoubleJumpPacket> CODEC = StreamCodec.unit((Object)new DoubleJumpPacket());

    void apply(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.DOUBLE_JUMP.value(), (LivingEntity)player2)) {
                context.queue(() -> {
                    DoubleJumpAbility.jump((Player)player2);
                    for (int i = 0; i < 20; ++i) {
                        double motionX = player2.getRandom().nextGaussian() * 0.02;
                        double motionY = player2.getRandom().nextGaussian() * 0.02 + 0.2;
                        double motionZ = player2.getRandom().nextGaussian() * 0.02;
                        SimpleParticleType particleType = player2.isInWater() ? ParticleTypes.BUBBLE : ParticleTypes.POOF;
                        player2.serverLevel().sendParticles((ParticleOptions)particleType, player2.getX(), player2.getY(), player2.getZ(), 1, motionX, motionY, motionZ, 0.15);
                    }
                });
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

