/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class RollLootTableModifier
extends LootModifier {
    public static final Supplier<MapCodec<RollLootTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> RollLootTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(m -> m.lootTable)).and((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(m -> m.replace)).apply((Applicative)instance, RollLootTableModifier::new)));
    private final ResourceKey<LootTable> lootTable;
    private final boolean replace;

    public RollLootTableModifier(LootItemCondition[] conditions, ResourceKey<LootTable> lootTable, boolean replace) {
        super(conditions);
        this.lootTable = lootTable;
        this.replace = replace;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.replace) {
            generatedLoot.clear();
        }
        context.getResolver().get(Registries.LOOT_TABLE, this.lootTable).ifPresent(table -> ((LootTable)table.value()).getRandomItemsRaw(context, arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0)));
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

