/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.mixin.accessors.client.LivingEntityRendererAccessor;
import artifacts.neoforge.client.ArmRenderHandler;
import artifacts.registry.ModLootTables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.client.render.CuriosLayer;

public class CuriosIntegrationClient {
    public static void setup(IEventBus modBus) {
        modBus.addListener(CuriosIntegrationClient::onAddLayers);
        ArmRenderHandler.setup();
    }

    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        Set<EntityType<?>> entities = ModLootTables.ENTITY_EQUIPMENT.keySet();
        block0: for (EntityType<?> entity : entities) {
            EntityRenderer renderer = event.getRenderer(entity);
            if (renderer == null) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            for (RenderLayer layer : ((LivingEntityRendererAccessor)livingEntityRenderer).getLayers()) {
                if (!(layer instanceof CuriosLayer)) continue;
                continue block0;
            }
            livingEntityRenderer.addLayer((RenderLayer)new CuriosLayer((RenderLayerParent)livingEntityRenderer));
        }
    }

    public static void registerArtifactRenderer(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)item, () -> new ArtifactCurioRenderer((ArtifactRenderer)rendererSupplier.get()));
    }

    public static ArtifactRenderer getArtifactRenderer(Item item) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactCurioRenderer) {
            ArtifactCurioRenderer artifactTrinketRenderer = (ArtifactCurioRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    public record ArtifactCurioRenderer(ArtifactRenderer renderer) implements ICurioRenderer
    {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.render(stack, slotContext.entity(), slotContext.index(), poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

