/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability.enchantment;

import artifacts.platform.PlatformServices;
import artifacts.util.AbilityHelper;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnchantmentHelper.class})
public class EnchantmentHelperMixin {
    @ModifyReturnValue(method={"getFishingTimeReduction(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;)F"}, at={@At(value="RETURN")})
    private static float increaseFishingTimeReduction(float original, ServerLevel level, ItemStack stack, Entity entity) {
        if (original > 25.0f) {
            return original;
        }
        if (PlatformServices.platformHelper.isFishingRod(stack) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return Math.min(25.0f, original + (float)(5 * AbilityHelper.getEnchantmentSum((ResourceKey<Enchantment>)Enchantments.LURE, livingEntity)));
        }
        return original;
    }

    @ModifyReturnValue(method={"getFishingLuckBonus(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;)I"}, at={@At(value="RETURN")})
    private static int increaseFishingLuckBonus(int original, ServerLevel level, ItemStack stack, Entity entity) {
        if (PlatformServices.platformHelper.isFishingRod(stack) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return original + AbilityHelper.getEnchantmentSum((ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, livingEntity);
        }
        return original;
    }
}

