/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability;

import artifacts.event.ArtifactEvents;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
        throw new UnsupportedOperationException();
    }

    @Shadow
    protected abstract ItemStack getLastArmorItem(EquipmentSlot var1);

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Inject(method={"handleEquipmentChanges(Ljava/util/Map;)V"}, at={@At(value="HEAD")})
    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> map, CallbackInfo info) {
        for (EquipmentSlot slot : map.keySet()) {
            if (!slot.isArmor()) continue;
            ItemStack oldStack = this.getLastArmorItem(slot);
            ItemStack newStack = this.getItemBySlot(slot);
            ArtifactEvents.onItemChanged((LivingEntity)this, oldStack, newStack);
        }
    }
}

