/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.item.ArtifactItem;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class UmbrellaItem
extends ArtifactItem {
    public UmbrellaItem() {
        super(new Item.Properties());
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public boolean isCosmetic() {
        return Artifacts.CONFIG.items.umbrellaIsGlider.get() == false && Artifacts.CONFIG.items.umbrellaIsShield.get() == false;
    }

    @Override
    protected void addEffectsTooltip(List<MutableComponent> tooltip) {
        if (Artifacts.CONFIG.items.umbrellaIsGlider.get().booleanValue()) {
            tooltip.add(this.tooltipLine("glider", new Object[0]));
        }
        if (Artifacts.CONFIG.items.umbrellaIsShield.get().booleanValue()) {
            tooltip.add(this.tooltipLine("shield", new Object[0]));
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!Artifacts.CONFIG.items.umbrellaIsShield.get().booleanValue()) {
            return super.use(level, player, hand);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public static void onLivingUpdate(LivingEntity entity) {
        if (UmbrellaItem.shouldGlide(entity)) {
            entity.fallDistance = 0.0f;
        }
    }

    public static boolean shouldGlide(LivingEntity entity) {
        boolean isInWater = entity.isInWater() && !AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SINKING.value(), entity);
        return Artifacts.CONFIG.items.umbrellaIsGlider.get() != false && !entity.onGround() && !isInWater && entity.getDeltaMovement().y < 0.0 && !entity.hasEffect(MobEffects.SLOW_FALLING) && UmbrellaItem.isHoldingUmbrellaUpright(entity);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity, InteractionHand hand) {
        return entity.getItemInHand(hand).getItem() instanceof UmbrellaItem && (!entity.isUsingItem() || entity.getUsedItemHand() != hand);
    }

    public static boolean isHoldingUmbrellaUpright(LivingEntity entity) {
        return UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.MAIN_HAND) || UmbrellaItem.isHoldingUmbrellaUpright(entity, InteractionHand.OFF_HAND);
    }
}

