/*
 * Decompiled with CFR 0.152.
 */
package artifacts.event;

import artifacts.Artifacts;
import artifacts.ability.ApplyCooldownAfterDamageAbility;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.AttractItemsAbility;
import artifacts.ability.SwimInAirAbility;
import artifacts.ability.mobeffect.ApplyMobEffectAfterDamageAbility;
import artifacts.ability.mobeffect.AttacksInflictMobEffectAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.attribute.DynamicAttributeModifier;
import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.MobAccessor;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModTags;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ArtifactEvents {
    public static void register() {
        PlayerEvent.DROP_ITEM.register(AttractItemsAbility::onItemToss);
        EntityEvent.LIVING_HURT.register(ArtifactEvents::onAttackBurningLivingHurt);
        EntityEvent.LIVING_HURT.register(ArtifactEvents::onPendantLivingHurt);
        EntityEvent.LIVING_HURT.register(ArtifactEvents::onLightningHurt);
        EntityEvent.LIVING_HURT.register(AttacksInflictMobEffectAbility::onLivingHurt);
        EntityEvent.ADD.register(ArtifactEvents::onEntityJoinWorld);
        TickEvent.PLAYER_PRE.register(SwimInAirAbility::onHeliumFlamingoTick);
    }

    public static void livingUpdate(LivingEntity entity) {
        ArtifactEvents.onItemTick(entity);
        UmbrellaItem.onLivingUpdate(entity);
        DynamicAttributeModifier.tickModifiers(entity);
    }

    public static void onLivingDamaged(LivingEntity entity, DamageSource source, float amount) {
        ArtifactEvents.absorbDamage(entity, source, amount);
        ApplyMobEffectAfterDamageAbility.onLivingDamaged(entity, source, amount);
        ApplyCooldownAfterDamageAbility.onLivingDamaged(entity, source);
    }

    public static void onItemChanged(LivingEntity entity, ItemStack oldStack, ItemStack newStack) {
        if (entity.level().isClientSide()) {
            return;
        }
        List oldAbilities = (List)oldStack.get((DataComponentType)ModDataComponents.ABILITIES.value());
        List newAbilities = (List)newStack.get((DataComponentType)ModDataComponents.ABILITIES.value());
        if (oldAbilities == null || oldAbilities.equals(newAbilities)) {
            return;
        }
        if (newAbilities == null) {
            newAbilities = List.of();
        }
        for (ArtifactAbility ability : oldAbilities) {
            if (newAbilities.contains(ability)) continue;
            boolean wasActive = ability.isEnabled() && AbilityHelper.isToggledOn(ability.getType(), entity);
            ability.onUnequip(entity, wasActive);
        }
    }

    public static void onItemTick(LivingEntity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> stack.has((DataComponentType)ModDataComponents.ABILITIES.value())).forEach(stack -> {
            for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                Player player;
                boolean isActive = ability.isActive(entity);
                boolean isOnCooldown = entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(stack.getItem());
                ability.wornTick(entity, isOnCooldown, isActive);
            }
        });
    }

    public static EventResult onAttackBurningLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.fireImmune()) {
            int duration = (int)attacker.getAttributeValue(ModAttributes.ATTACK_BURNING_DURATION);
            entity.igniteForSeconds((float)duration);
        }
        return EventResult.pass();
    }

    private static EventResult onPendantLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        ArtifactEvents.activateRetaliationAbility((ArtifactAbility.Type)ModAbilities.SET_ATTACKERS_ON_FIRE.value(), entity, damageSource, amount);
        ArtifactEvents.activateRetaliationAbility((ArtifactAbility.Type)ModAbilities.THORNS.value(), entity, damageSource, amount);
        return EventResult.pass();
    }

    private static void activateRetaliationAbility(ArtifactAbility.Type<? extends RetaliationAbility> type, LivingEntity entity, DamageSource damageSource, float amount) {
        AbilityHelper.forEach(type, entity, (ability, stack) -> ability.onLivingHurt(entity, (ItemStack)stack, damageSource, amount), true);
    }

    private static EventResult onEntityJoinWorld(Entity entity, Level level) {
        PathfinderMob creeper;
        if (entity instanceof PathfinderMob && (creeper = (PathfinderMob)entity).getType().is(ModTags.CREEPERS)) {
            Predicate<LivingEntity> predicate = target -> AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SCARE_CREEPERS.value(), target);
            ((MobAccessor)creeper).getGoalSelector().addGoal(3, (Goal)new AvoidEntityGoal(creeper, Player.class, predicate, 6.0f, 1.0, 1.3, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        }
        return EventResult.pass();
    }

    public static void onPlaySoundAtEntity(LivingEntity entity, float volume, float pitch) {
        if (Artifacts.CONFIG.general.modifyHurtSounds.get().booleanValue()) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.MODIFY_HURT_SOUND.value(), entity, ability -> entity.playSound((SoundEvent)ability.soundEvent().value(), volume, pitch));
        }
    }

    private static EventResult onLightningHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        if (!entity.level().isClientSide() && amount > 0.0f && AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.DAMAGE_IMMUNITY.value(), entity, ability -> damageSource.is(ability.tag()))) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static ItemStack applySmeltOresAbility(ItemStack original, @Nullable Entity entity, @Nullable BlockState state, Consumer<Integer> experienceConsumer) {
        if (entity instanceof LivingEntity) {
            ItemStack smeltingResult;
            Optional recipe;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SMELT_ORES.value(), livingEntity) && state != null && state.is(ModTags.ORES) && original.is(ModTags.RAW_MATERIALS) && (recipe = livingEntity.level().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(original), livingEntity.level())).isPresent() && !(smeltingResult = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)livingEntity.level().registryAccess())).isEmpty()) {
                experienceConsumer.accept(ArtifactEvents.getExperience(((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getExperience()));
                return smeltingResult.copyWithCount(smeltingResult.getCount() * original.getCount());
            }
        }
        return original;
    }

    private static int getExperience(float experience) {
        int amount = Mth.floor((float)experience);
        if (Math.random() < (double)Mth.frac((float)experience)) {
            ++amount;
        }
        return amount;
    }

    public static int modifyUseDuration(int originalDuration, ItemStack item, LivingEntity entity) {
        if (originalDuration <= 0) {
            return originalDuration;
        }
        if (item.getUseAnimation() == UseAnim.EAT) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.getAttributeValue(ModAttributes.EATING_SPEED)));
        }
        if (item.getUseAnimation() == UseAnim.DRINK) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.getAttributeValue(ModAttributes.DRINKING_SPEED)));
        }
        return originalDuration;
    }

    public static int modifyExperience(int originalXp, LivingEntity entity, Player attacker) {
        if (attacker == null || entity instanceof Player || originalXp <= 0) {
            return originalXp;
        }
        double multiplier = attacker.getAttributeValue(ModAttributes.ENTITY_EXPERIENCE);
        int droppedXp = (int)Math.round((double)originalXp * multiplier);
        return Math.max(0, droppedXp);
    }

    public static void absorbDamage(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource)) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.ATTACKS_ABSORB_DAMAGE.value(), attacker, ability -> {
                float damageDealt;
                double absorptionRatio = (Double)ability.absorptionRatio().get();
                double maxHealthAbsorbed = ((Integer)ability.maxDamageAbsorbed().get()).intValue();
                float damageAbsorbed = (float)Math.min(maxHealthAbsorbed, absorptionRatio * (double)(damageDealt = Math.min(amount, entity.getHealth())));
                if (damageAbsorbed > 0.0f && (Double)ability.absorptionChance().get() > entity.getRandom().nextDouble()) {
                    attacker.heal(damageAbsorbed);
                }
            });
        }
    }

    public static float getModifiedFriction(float friction, LivingEntity entity, Block block) {
        if (ModTags.isInTag(block, BlockTags.ICE) && friction > 0.6f) {
            double slipperinessReduction = entity.getAttributeValue(ModAttributes.SLIP_RESISTANCE);
            return Mth.lerp((float)((float)slipperinessReduction), (float)friction, (float)0.6f);
        }
        return friction;
    }

    public static void applyBoneMealAfterEating(LivingEntity entity, FoodProperties properties) {
        if (!entity.level().isClientSide() && AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.GROW_PLANTS_AFTER_EATING.value(), entity) && properties.nutrition() > 0 && !properties.canAlwaysEat() && entity.onGround() && entity.getBlockStateOn().is(ModTags.ROOTED_BOOTS_GRASS)) {
            BoneMealItem.growCrop((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)entity.level(), (BlockPos)entity.getOnPos());
        }
    }
}

