/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.ability.ArtifactAbility;
import artifacts.network.UpdateArtifactTogglesPacket;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class AbilityToggles {
    public static final Codec<AbilityToggles> CODEC = ResourceLocation.CODEC.listOf().xmap(list -> {
        HashSet toggles = new HashSet();
        for (ResourceLocation id : list) {
            toggles.add((ArtifactAbility.Type)ModAbilities.REGISTRY.get(id));
        }
        return new AbilityToggles(toggles);
    }, abilityToggles -> {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (ArtifactAbility.Type<?> toggle : abilityToggles.toggles) {
            ResourceLocation id = ModAbilities.REGISTRY.getId(toggle);
            list.add(id);
        }
        return list;
    });
    protected final Set<ArtifactAbility.Type<?>> toggles = new HashSet();

    public AbilityToggles() {
        this(Set.of());
    }

    public AbilityToggles(Collection<ArtifactAbility.Type<?>> toggles) {
        this.toggles.addAll(toggles);
    }

    public boolean isToggledOn(ArtifactAbility.Type<?> type) {
        return !this.toggles.contains(type);
    }

    public void toggle(ArtifactAbility.Type<?> type, LivingEntity entity) {
        if (this.toggles.contains(type)) {
            this.toggles.remove(type);
        } else {
            this.toggles.add(type);
            if (!entity.level().isClientSide()) {
                AbilityHelper.forEach(type, entity, ability -> ability.onUnequip(entity, ability.isEnabled()));
            }
        }
    }

    public void applyToggles(Collection<ArtifactAbility.Type<?>> toggles, LivingEntity entity) {
        for (ArtifactAbility.Type type : Set.copyOf(Sets.symmetricDifference(this.toggles, Set.copyOf(toggles)))) {
            this.toggle(type, entity);
        }
    }

    public void sendToClient(ServerPlayer player) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateArtifactTogglesPacket(List.copyOf(this.toggles)));
    }
}

