/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item;

import artifacts.client.item.ArtifactLayers;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.model.BeltModel;
import artifacts.client.item.model.HeadModel;
import artifacts.client.item.model.LegsModel;
import artifacts.client.item.model.NecklaceModel;
import artifacts.client.item.model.ScarfModel;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.BeltArtifactRenderer;
import artifacts.client.item.renderer.BootArtifactRenderer;
import artifacts.client.item.renderer.GenericArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.client.item.renderer.GlowingArtifactRenderer;
import artifacts.client.item.renderer.GlowingGloveArtifactRenderer;
import artifacts.client.item.renderer.WarpDriveRenderer;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class ArtifactRenderers {
    public static void register() {
        ArtifactRenderers.register((Item)ModItems.PLASTIC_DRINKING_HAT.value(), () -> new GenericArtifactRenderer("plastic_drinking_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.DRINKING_HAT))));
        ArtifactRenderers.register((Item)ModItems.NOVELTY_DRINKING_HAT.value(), () -> new GenericArtifactRenderer("novelty_drinking_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.DRINKING_HAT))));
        ArtifactRenderers.register((Item)ModItems.SNORKEL.value(), () -> new GenericArtifactRenderer("snorkel", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.SNORKEL), RenderType::entityTranslucent)));
        ArtifactRenderers.register((Item)ModItems.NIGHT_VISION_GOGGLES.value(), () -> new GlowingArtifactRenderer("night_vision_goggles", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.NIGHT_VISION_GOGGLES))));
        ArtifactRenderers.register((Item)ModItems.SUPERSTITIOUS_HAT.value(), () -> new GenericArtifactRenderer("superstitious_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.SUPERSTITIOUS_HAT), RenderType::entityCutoutNoCull)));
        ArtifactRenderers.register((Item)ModItems.VILLAGER_HAT.value(), () -> new GenericArtifactRenderer("villager_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.BRIMMED_HAT))));
        ArtifactRenderers.register((Item)ModItems.COWBOY_HAT.value(), () -> new GenericArtifactRenderer("cowboy_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.COWBOY_HAT))));
        ArtifactRenderers.register((Item)ModItems.ANGLERS_HAT.value(), () -> new GenericArtifactRenderer("anglers_hat", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.ANGLERS_HAT))));
        ArtifactRenderers.register((Item)ModItems.LUCKY_SCARF.value(), () -> new GenericArtifactRenderer("lucky_scarf", (HumanoidModel<LivingEntity>)new ScarfModel(ArtifactRenderers.bakeLayer(ArtifactLayers.SCARF), RenderType::entityCutoutNoCull)));
        ArtifactRenderers.register((Item)ModItems.SCARF_OF_INVISIBILITY.value(), () -> new GenericArtifactRenderer("scarf_of_invisibility", (HumanoidModel<LivingEntity>)new ScarfModel(ArtifactRenderers.bakeLayer(ArtifactLayers.SCARF), RenderType::entityTranslucent)));
        ArtifactRenderers.register((Item)ModItems.CROSS_NECKLACE.value(), () -> new GenericArtifactRenderer("cross_necklace", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.CROSS_NECKLACE))));
        ArtifactRenderers.register((Item)ModItems.PANIC_NECKLACE.value(), () -> new GenericArtifactRenderer("panic_necklace", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.PANIC_NECKLACE))));
        ArtifactRenderers.register((Item)ModItems.SHOCK_PENDANT.value(), () -> new GenericArtifactRenderer("shock_pendant", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.PENDANT))));
        ArtifactRenderers.register((Item)ModItems.FLAME_PENDANT.value(), () -> new GenericArtifactRenderer("flame_pendant", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.PENDANT))));
        ArtifactRenderers.register((Item)ModItems.THORN_PENDANT.value(), () -> new GenericArtifactRenderer("thorn_pendant", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.PENDANT))));
        ArtifactRenderers.register((Item)ModItems.CHARM_OF_SINKING.value(), () -> new GenericArtifactRenderer("charm_of_sinking", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.CHARM_OF_SINKING))));
        ArtifactRenderers.register((Item)ModItems.CHARM_OF_SHRINKING.value(), () -> new GenericArtifactRenderer("charm_of_shrinking", (HumanoidModel<LivingEntity>)new NecklaceModel(ArtifactRenderers.bakeLayer(ArtifactLayers.CHARM_OF_SHRINKING))));
        ArtifactRenderers.register((Item)ModItems.CLOUD_IN_A_BOTTLE.value(), () -> new BeltArtifactRenderer("cloud_in_a_bottle", BeltModel.createCloudInABottleModel()));
        ArtifactRenderers.register((Item)ModItems.OBSIDIAN_SKULL.value(), () -> new BeltArtifactRenderer("obsidian_skull", BeltModel.createObsidianSkullModel()));
        ArtifactRenderers.register((Item)ModItems.ANTIDOTE_VESSEL.value(), () -> new BeltArtifactRenderer("antidote_vessel", BeltModel.createAntidoteVesselModel()));
        ArtifactRenderers.register((Item)ModItems.UNIVERSAL_ATTRACTOR.value(), () -> new BeltArtifactRenderer("universal_attractor", BeltModel.createUniversalAttractorModel()));
        ArtifactRenderers.register((Item)ModItems.CRYSTAL_HEART.value(), () -> new BeltArtifactRenderer("crystal_heart", BeltModel.createCrystalHeartModel()));
        ArtifactRenderers.register((Item)ModItems.HELIUM_FLAMINGO.value(), () -> new GenericArtifactRenderer("helium_flamingo", BeltModel.createHeliumFlamingoModel()));
        ArtifactRenderers.register((Item)ModItems.CHORUS_TOTEM.value(), () -> new BeltArtifactRenderer("chorus_totem", BeltModel.createChorusTotemModel()));
        ArtifactRenderers.register((Item)ModItems.WARP_DRIVE.value(), () -> new WarpDriveRenderer("warp_drive", BeltModel.createWarpDriveModel()));
        ArtifactRenderers.register((Item)ModItems.DIGGING_CLAWS.value(), () -> new GloveArtifactRenderer("digging_claws", "digging_claws", ArmsModel::createClawsModel));
        ArtifactRenderers.register((Item)ModItems.FERAL_CLAWS.value(), () -> new GloveArtifactRenderer("feral_claws", "feral_claws", ArmsModel::createClawsModel));
        ArtifactRenderers.register((Item)ModItems.POWER_GLOVE.value(), () -> new GloveArtifactRenderer("power_glove", ArmsModel::createGloveModel));
        ArtifactRenderers.register((Item)ModItems.FIRE_GAUNTLET.value(), () -> new GlowingGloveArtifactRenderer("fire_gauntlet", ArmsModel::createGloveModel));
        ArtifactRenderers.register((Item)ModItems.POCKET_PISTON.value(), () -> new GloveArtifactRenderer("pocket_piston", ArmsModel::createPocketPistonModel));
        ArtifactRenderers.register((Item)ModItems.VAMPIRIC_GLOVE.value(), () -> new GloveArtifactRenderer("vampiric_glove", ArmsModel::createGloveModel));
        ArtifactRenderers.register((Item)ModItems.GOLDEN_HOOK.value(), () -> new GloveArtifactRenderer("golden_hook", ArmsModel::createGoldenHookModel));
        ArtifactRenderers.register((Item)ModItems.ONION_RING.value(), () -> new GloveArtifactRenderer("onion_ring", ArmsModel::createOnionRingModel));
        ArtifactRenderers.register((Item)ModItems.PICKAXE_HEATER.value(), () -> new GlowingGloveArtifactRenderer("pickaxe_heater", ArmsModel::createPickaxeHeaterModel));
        ArtifactRenderers.register((Item)ModItems.WITHERED_BRACELET.value(), () -> new GloveArtifactRenderer("withered_bracelet", ArmsModel::createWitheredBraceletModel));
        ArtifactRenderers.register((Item)ModItems.AQUA_DASHERS.value(), () -> new BootArtifactRenderer("aqua_dashers", hasArmor -> new LegsModel(ArtifactRenderers.bakeLayer(hasArmor != false ? ArtifactLayers.AQUA_DASHERS_LARGE : ArtifactLayers.AQUA_DASHERS_SMALL))));
        ArtifactRenderers.register((Item)ModItems.BUNNY_HOPPERS.value(), () -> new GenericArtifactRenderer("bunny_hoppers", (HumanoidModel<LivingEntity>)new LegsModel(ArtifactRenderers.bakeLayer(ArtifactLayers.BUNNY_HOPPERS))));
        ArtifactRenderers.register((Item)ModItems.KITTY_SLIPPERS.value(), () -> new GenericArtifactRenderer("kitty_slippers", (HumanoidModel<LivingEntity>)new LegsModel(ArtifactRenderers.bakeLayer(ArtifactLayers.KITTY_SLIPPERS))));
        ArtifactRenderers.register((Item)ModItems.RUNNING_SHOES.value(), () -> new BootArtifactRenderer("running_shoes", hasArmor -> new LegsModel(ArtifactRenderers.bakeLayer(hasArmor != false ? ArtifactLayers.BOOTS_LARGE : ArtifactLayers.BOOTS_SMALL))));
        ArtifactRenderers.register((Item)ModItems.SNOWSHOES.value(), () -> new GenericArtifactRenderer("snowshoes", (HumanoidModel<LivingEntity>)new LegsModel(ArtifactRenderers.bakeLayer(ArtifactLayers.SNOWSHOES))));
        ArtifactRenderers.register((Item)ModItems.STEADFAST_SPIKES.value(), () -> new GenericArtifactRenderer("steadfast_spikes", (HumanoidModel<LivingEntity>)new LegsModel(ArtifactRenderers.bakeLayer(ArtifactLayers.STEADFAST_SPIKES))));
        ArtifactRenderers.register((Item)ModItems.FLIPPERS.value(), () -> new GenericArtifactRenderer("flippers", (HumanoidModel<LivingEntity>)new LegsModel(ArtifactRenderers.bakeLayer(ArtifactLayers.FLIPPERS))));
        ArtifactRenderers.register((Item)ModItems.ROOTED_BOOTS.value(), () -> new BootArtifactRenderer("rooted_boots", hasArmor -> new LegsModel(ArtifactRenderers.bakeLayer(hasArmor != false ? ArtifactLayers.BOOTS_LARGE : ArtifactLayers.BOOTS_SMALL))));
        ArtifactRenderers.register((Item)ModItems.STRIDER_SHOES.value(), () -> new BootArtifactRenderer("strider_shoes", hasArmor -> new LegsModel(ArtifactRenderers.bakeLayer(hasArmor != false ? ArtifactLayers.BOOTS_LARGE : ArtifactLayers.BOOTS_SMALL))));
        ArtifactRenderers.register((Item)ModItems.WHOOPEE_CUSHION.value(), () -> new GenericArtifactRenderer("whoopee_cushion", (HumanoidModel<LivingEntity>)new HeadModel(ArtifactRenderers.bakeLayer(ArtifactLayers.WHOOPEE_CUSHION))));
    }

    public static ModelPart bakeLayer(ModelLayerLocation layerLocation) {
        return Minecraft.getInstance().getEntityModels().bakeLayer(layerLocation);
    }

    public static void register(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, rendererSupplier);
    }
}

