/*
 * Decompiled with CFR 0.152.
 */
package artifacts.attribute;

import artifacts.Artifacts;
import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.EntityAccessor;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModTags;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class DynamicAttributeModifier {
    private static final List<DynamicAttributeModifier> MODIFIERS = List.of(new DynamicAttributeModifier(Artifacts.id("mount_speed"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, entity -> entity.getControllingPassenger() != null, entity -> Objects.requireNonNull(entity.getControllingPassenger()).getAttributeValue(ModAttributes.MOUNT_SPEED) - 1.0), new DynamicAttributeModifier(Artifacts.id("sprinting_speed"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, Entity::isSprinting, entity -> entity.getAttributeValue(ModAttributes.SPRINTING_SPEED) - 1.0), new DynamicAttributeModifier(Artifacts.id("sprinting_step_height"), (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE, Entity::isSprinting, entity -> entity.getAttributeValue(ModAttributes.SPRINTING_STEP_HEIGHT)), new DynamicAttributeModifier(Artifacts.id("umbrella_gravity"), (Holder<Attribute>)Attributes.GRAVITY, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, UmbrellaItem::shouldGlide, entity -> -0.875), new DynamicAttributeModifier(Artifacts.id("movement_speed_on_snow"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, entity -> {
        if (entity.getAttributeValue(ModAttributes.MOVEMENT_SPEED_ON_SNOW) == 1.0) return false;
        if (!entity.onGround()) return false;
        if (!(entity instanceof EntityAccessor)) return false;
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (entity.level().getBlockState(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement()).is(BlockTags.SNOW)) return true;
        if (!entity.level().getBlockState(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement().above()).is(ModTags.SNOW_LAYERS)) return false;
        return true;
    }, entity -> {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().flying) {
                return true;
            }
        }
        return entity.onGround() || entity.isFallFlying();
    }, entity -> entity.getAttributeValue(ModAttributes.MOVEMENT_SPEED_ON_SNOW) - 1.0));
    private final Holder<Attribute> attribute;
    private final AttributeModifier.Operation operation;
    private final ResourceLocation id;
    private final Predicate<LivingEntity> shouldApply;
    private final Predicate<LivingEntity> shouldUpdate;
    private final Function<LivingEntity, Double> amount;

    public DynamicAttributeModifier(ResourceLocation id, Holder<Attribute> attribute, AttributeModifier.Operation operation, Predicate<LivingEntity> shouldApply, Function<LivingEntity, Double> amount) {
        this(id, attribute, operation, shouldApply, entity -> true, amount);
    }

    public DynamicAttributeModifier(ResourceLocation id, Holder<Attribute> attribute, AttributeModifier.Operation operation, Predicate<LivingEntity> shouldApply, Predicate<LivingEntity> shouldUpdate, Function<LivingEntity, Double> amount) {
        this.attribute = attribute;
        this.operation = operation;
        this.id = id;
        this.shouldApply = shouldApply;
        this.shouldUpdate = shouldUpdate;
        this.amount = amount;
    }

    public static void tickModifiers(LivingEntity entity) {
        for (DynamicAttributeModifier modifier : MODIFIERS) {
            modifier.tick(entity);
        }
    }

    private void tick(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.getAttribute(this.attribute);
        if (attributeInstance == null || !this.shouldUpdate.test(entity)) {
            return;
        }
        if (this.shouldApply.test(entity)) {
            double amount = this.amount.apply(entity);
            AttributeModifier modifier = attributeInstance.getModifier(this.id);
            if (modifier == null || modifier.amount() != amount) {
                attributeInstance.addOrUpdateTransientModifier(new AttributeModifier(this.id, amount, this.operation));
            }
        } else {
            attributeInstance.removeModifier(this.id);
        }
    }
}

