/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class StrikeAttackersWithLightningAbility
extends RetaliationAbility {
    public static final MapCodec<StrikeAttackersWithLightningAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> StrikeAttackersWithLightningAbility.codecStart(instance).apply((Applicative)instance, StrikeAttackersWithLightningAbility::new));
    public static final StreamCodec<ByteBuf, StrikeAttackersWithLightningAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationAbility::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationAbility::cooldown, StrikeAttackersWithLightningAbility::new);

    public StrikeAttackersWithLightningAbility(Value<Double> strikeChance, Value<Integer> cooldown) {
        super(strikeChance, cooldown);
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.STRIKE_ATTACKERS_WITH_LIGHTNING.value();
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        LightningBolt lightningBolt;
        if (attacker.level().canSeeSky(BlockPos.containing((Position)attacker.position())) && (lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(attacker.level())) != null) {
            ServerPlayer player;
            lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)attacker.blockPosition()));
            lightningBolt.setCause(attacker instanceof ServerPlayer ? (player = (ServerPlayer)attacker) : null);
            attacker.level().addFreshEntity((Entity)lightningBolt);
        }
    }
}

