/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;

public record UpgradeToolTierAbility(Value<Tier> tier) implements ArtifactAbility
{
    public static final MapCodec<UpgradeToolTierAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.TOOL_TIER.codec().fieldOf("tier").forGetter(UpgradeToolTierAbility::tier)).apply((Applicative)instance, UpgradeToolTierAbility::new));
    public static final StreamCodec<ByteBuf, UpgradeToolTierAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.TOOL_TIER.streamCodec(), UpgradeToolTierAbility::tier, UpgradeToolTierAbility::new);

    public static boolean canHarvestWithTier(LivingEntity entity, BlockState state) {
        if (state.is(ModTags.MINEABLE_WITH_DIGGING_CLAWS)) {
            Tier tier = Tier.fromLevel(AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.UPGRADE_TOOL_TIER.value(), entity, ability -> ((Tier)((Object)((Object)ability.tier().get()))).getLevel(), false));
            return UpgradeToolTierAbility.isCorrectTierForDrops(tier, state);
        }
        return false;
    }

    public static boolean isCorrectTierForDrops(Tier tier, BlockState state) {
        if (!state.requiresCorrectToolForDrops()) {
            return true;
        }
        int i = tier.getLevel();
        if (state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return i >= 4;
        }
        if (state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return i >= 3;
        }
        if (state.is(BlockTags.NEEDS_STONE_TOOL)) {
            return i >= 2;
        }
        return i >= 1;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.UPGRADE_TOOL_TIER.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return this.tier().get() != Tier.NONE;
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        ResourceLocation id = ModAbilities.REGISTRY.getId(this.getType());
        tooltip.add(Component.translatable((String)"%s.tooltip.ability.%s".formatted(id.getNamespace(), id.getPath()), (Object[])new Object[]{UpgradeToolTierAbility.getTierName((Tier)((Object)this.tier.get()))}));
    }

    public static Component getTierName(Tier tier) {
        return Component.translatable((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tier.getSerializedName()));
    }

    public static enum Tier implements StringRepresentable
    {
        NONE(0),
        WOOD(1),
        STONE(2),
        IRON(3),
        DIAMOND(4),
        NETHERITE(5);

        private final int level;

        private Tier(int level) {
            this.level = level;
        }

        public static Tier fromLevel(int level) {
            return switch (level) {
                case 0 -> NONE;
                case 1 -> WOOD;
                case 2 -> STONE;
                case 3 -> IRON;
                case 4 -> DIAMOND;
                default -> NETHERITE;
            };
        }

        public int getLevel() {
            return this.level;
        }

        public String getSerializedName() {
            return this.toString().toLowerCase();
        }
    }
}

