/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public record TeleportOnDeathAbility(Value<Double> teleportationChance, Value<Integer> healthRestored, Value<Integer> cooldown, Value<Boolean> consumedOnUse) implements ArtifactAbility
{
    public static final MapCodec<TeleportOnDeathAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(TeleportOnDeathAbility::teleportationChance), (App)ValueTypes.NON_NEGATIVE_INT.codec().optionalFieldOf("health_restored", Value.of(10)).forGetter(TeleportOnDeathAbility::healthRestored), (App)ValueTypes.cooldownField().forGetter(TeleportOnDeathAbility::cooldown), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("consume", Value.of(true)).forGetter(TeleportOnDeathAbility::consumedOnUse)).apply((Applicative)instance, TeleportOnDeathAbility::new));
    public static final StreamCodec<ByteBuf, TeleportOnDeathAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), TeleportOnDeathAbility::teleportationChance, ValueTypes.NON_NEGATIVE_INT.streamCodec(), TeleportOnDeathAbility::healthRestored, ValueTypes.DURATION.streamCodec(), TeleportOnDeathAbility::cooldown, ValueTypes.BOOLEAN.streamCodec(), TeleportOnDeathAbility::consumedOnUse, TeleportOnDeathAbility::new);

    public static ItemStack findTotem(LivingEntity entity) {
        for (InteractionHand hand : InteractionHand.values()) {
            Player player;
            ItemStack handItem = entity.getItemInHand(hand);
            if (!AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.TELEPORT_ON_DEATH.value(), handItem) || entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(handItem.getItem())) continue;
            return handItem;
        }
        return PlatformServices.platformHelper.findAllEquippedBy(entity, stack -> {
            Player player;
            return AbilityHelper.hasAbility((ArtifactAbility.Type)ModAbilities.TELEPORT_ON_DEATH.value(), stack) && (!(entity instanceof Player) || !(player = (Player)entity).getCooldowns().isOnCooldown(stack.getItem()));
        }).findFirst().orElse(ItemStack.EMPTY);
    }

    public static void teleport(LivingEntity entity, ServerLevel level) {
        double oldX = entity.getX();
        double oldY = entity.getY();
        double oldZ = entity.getZ();
        for (int i = 0; i < 32; ++i) {
            double newX = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
            double newY = Mth.clamp((double)(entity.getY() + (double)entity.getRandom().nextInt(16) - 8.0), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + level.getLogicalHeight() - 1));
            double newZ = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 32.0;
            Vec3 oldPos = entity.position();
            if (oldPos.distanceToSqr(newX, newY, newZ) < 256.0) continue;
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            if (!entity.randomTeleport(newX, newY, newZ, true)) continue;
            entity.level().gameEvent((Holder)GameEvent.TELEPORT, oldPos, GameEvent.Context.of((Entity)entity));
            entity.level().playSound(null, oldX, oldY, oldZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.level().playSound(null, newX, newY, newZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.TELEPORT_ON_DEATH.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.teleportationChance().get()), (double)0.0);
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (Mth.equal((double)((Double)this.teleportationChance().get()), (double)0.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
        if (!((Boolean)this.consumedOnUse().get()).booleanValue()) {
            tooltip.add(this.tooltipLine("not_consumed", new Object[0]));
        }
    }
}

