/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.ApplyMobEffectAfterEatingAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.network.PlaySoundAtPlayerPacket;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;

public record ReplenishHungerOnGrassAbility(Value<Boolean> enabled, Value<Integer> replenishingDuration) implements ArtifactAbility
{
    public static final MapCodec<ReplenishHungerOnGrassAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.enabledField().forGetter(ReplenishHungerOnGrassAbility::enabled), (App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(ReplenishHungerOnGrassAbility::replenishingDuration)).apply((Applicative)instance, ReplenishHungerOnGrassAbility::new));
    public static final StreamCodec<ByteBuf, ReplenishHungerOnGrassAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), ReplenishHungerOnGrassAbility::enabled, ValueTypes.DURATION.streamCodec(), ReplenishHungerOnGrassAbility::replenishingDuration, ReplenishHungerOnGrassAbility::new);

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.REPLENISH_HUNGER_ON_GRASS.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
        ServerPlayer player;
        if (isActive && entity instanceof ServerPlayer && (player = (ServerPlayer)entity).onGround() && player.getFoodData().needsFood() && entity.tickCount % (Math.max(1, (Integer)this.replenishingDuration().get()) * 20) == 0 && entity.getBlockStateOn().is(ModTags.ROOTED_BOOTS_GRASS)) {
            player.getFoodData().eat(1, 0.5f);
            ApplyMobEffectAfterEatingAbility.applyEffects(entity, 1);
            PlaySoundAtPlayerPacket.sendSound(player, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.GENERIC_EAT), 0.5f, 0.8f + entity.getRandom().nextFloat() * 0.4f);
        }
    }
}

