/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.menu;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.forge.MenuRegistryImpl;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class MenuRegistry {
    private MenuRegistry() {
    }

    public static void openExtendedMenu(ServerPlayer player, final MenuProvider provider, final Consumer<FriendlyByteBuf> bufWriter) {
        MenuRegistry.openExtendedMenu(player, new ExtendedMenuProvider(){

            @Override
            public void saveExtraData(FriendlyByteBuf buf) {
                bufWriter.accept(buf);
            }

            public Component getDisplayName() {
                return provider.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openExtendedMenu(ServerPlayer player, ExtendedMenuProvider provider) {
        void var1_1;
        MenuRegistryImpl.openExtendedMenu(player, (ExtendedMenuProvider)var1_1);
    }

    public static void openMenu(ServerPlayer player, MenuProvider provider) {
        player.openMenu(provider);
    }

    @Deprecated(forRemoval=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends AbstractContainerMenu> MenuType<T> of(SimpleMenuTypeFactory<T> factory) {
        return MenuRegistryImpl.of(factory);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends AbstractContainerMenu> MenuType<T> ofExtended(ExtendedMenuTypeFactory<T> factory) {
        return MenuRegistryImpl.ofExtended(factory);
    }

    /*
     * WARNING - void declaration
     */
    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <H extends AbstractContainerMenu, S extends Screen> void registerScreenFactory(MenuType<? extends H> type, ScreenFactory<H, S> factory) {
        void var1_1;
        MenuRegistryImpl.registerScreenFactory(type, var1_1);
    }

    @FunctionalInterface
    public static interface ExtendedMenuTypeFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, FriendlyByteBuf var3);
    }

    @Deprecated(forRemoval=true)
    @FunctionalInterface
    public static interface SimpleMenuTypeFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ScreenFactory<H extends AbstractContainerMenu, S extends Screen> {
        public S create(H var1, Inventory var2, Component var3);
    }
}

