/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.neoforge.item;

import dev.denismasterherobrine.angelring.configuration.Configuration;
import dev.denismasterherobrine.angelring.utils.AngelRingMode;
import dev.denismasterherobrine.angelring.utils.AngelRingModeSelector;
import dev.denismasterherobrine.angelring.utils.ExperienceUtils;
import dev.denismasterherobrine.flightapi.api.FlightAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class AngelRingItem
extends Item
implements ICurioItem {
    private int ticksDrained;
    private static final Map<UUID, Boolean> flightPermissionMap = new HashMap<UUID, Boolean>();

    public AngelRingItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).durability(Configuration.DurabilityAmount).fireResistant());
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FlightAPI.requestFlight((String)"angelring", (ServerPlayer)player);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            UUID playerUUID = player.getGameProfile().getId();
            AngelRingMode mode = AngelRingModeSelector.getMode();
            if (flightPermissionMap.containsKey(playerUUID) && mode == AngelRingMode.XP && Boolean.TRUE.equals(flightPermissionMap.get(playerUUID)) && ExperienceUtils.getPlayerXP((Player)player) >= (long)Configuration.XPConsumptionRate) {
                FlightAPI.requestFlight((String)"angelring", (ServerPlayer)player);
                player.displayClientMessage((Component)Component.translatable((String)"angelring.xp.flight_restored").withColor(TextColor.fromRgb((int)9229895).getValue()), true);
                flightPermissionMap.put(playerUUID, false);
            }
            FlightAPI.getCurrentOwner((UUID)playerUUID).ifPresent(owner -> {
                if (mode == AngelRingMode.XP) {
                    ++this.ticksDrained;
                    if (this.ticksDrained > Configuration.XPTickingRate) {
                        if (!player.onGround()) {
                            if (ExperienceUtils.getPlayerXP((Player)player) >= (long)Configuration.XPConsumptionRate) {
                                ExperienceUtils.addPlayerXP((Player)player, -Configuration.XPConsumptionRate);
                            } else {
                                FlightAPI.releaseFlight((String)"angelring", (ServerPlayer)player);
                                player.displayClientMessage((Component)Component.translatable((String)"angelring.xp.no_more_xp").withColor(TextColor.fromRgb((int)14056293).getValue()), true);
                                flightPermissionMap.put(playerUUID, true);
                            }
                        }
                        this.ticksDrained = 0;
                    }
                }
                if (mode == AngelRingMode.DURABILITY) {
                    ++this.ticksDrained;
                    if (this.ticksDrained >= Configuration.DurabilityTickingRate) {
                        if (!player.onGround()) {
                            if ((double)stack.getDamageValue() >= (double)stack.getMaxDamage() * 0.95) {
                                player.displayClientMessage((Component)Component.translatable((String)"angelring.durability.low_durability").withColor(TextColor.fromRgb((int)14056293).getValue()), true);
                            }
                            stack.setDamageValue(stack.getDamageValue() + Configuration.DurabilityConsumptionRate);
                        }
                        if (stack.getDamageValue() >= stack.getMaxDamage()) {
                            player.playNotifySound(stack.getBreakingSound(), SoundSource.MASTER, 1.0f, 1.0f);
                            stack.shrink(1);
                            FlightAPI.releaseFlight((String)"angelring", (ServerPlayer)player);
                            player.displayClientMessage((Component)Component.translatable((String)"angelring.durability.broken").withColor(TextColor.fromRgb((int)14691372).getValue()), true);
                        }
                        this.ticksDrained = 0;
                    }
                }
            });
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (AngelRingItem.isAngelRingEquipped((LivingEntity)player)) {
                return;
            }
            FlightAPI.releaseFlight((String)"angelring", (ServerPlayer)player);
        }
    }

    public SoundEvent getBreakingSound() {
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block.glass.break"));
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item.armor.equip_elytra")), 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (AngelRingModeSelector.getMode() == AngelRingMode.XP) {
            tooltip.add((Component)Component.translatable((String)"item.angelring.angel_ring.desc0"));
            tooltip.add((Component)Component.translatable((String)"item.angelring.angel_ring.desc1"));
            tooltip.add((Component)Component.translatable((String)"item.angelring.angel_ring.desc2"));
        } else if (AngelRingModeSelector.getMode() == AngelRingMode.DURABILITY) {
            tooltip.add((Component)Component.translatable((String)"angelring.durability.tooltip"));
        } else if (AngelRingModeSelector.getMode() == AngelRingMode.CLASSIC) {
            tooltip.add((Component)Component.translatable((String)"item.angelring.angel_ring.classic.desc0_1"));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    private static boolean isAngelRingEquipped(LivingEntity entity) {
        AtomicBoolean isFound = new AtomicBoolean(false);
        ICuriosItemHandler curiosInventory = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).get();
        Map curios = curiosInventory.getCurios();
        curios.forEach((identifier, slotInventory) -> {
            IDynamicStackHandler stacksHandler = slotInventory.getStacks();
            for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                ItemStack stack = stacksHandler.getStackInSlot(i);
                if (!(stack.getItem() instanceof AngelRingItem)) continue;
                isFound.set(true);
                return;
            }
        });
        return isFound.get();
    }
}

