/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.items;

import com.mgen256.al.FireTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.Pedestal;
import com.mgen256.al.items.Wand;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class SoulWand
extends Wand {
    private static Item.Properties createProps() {
        Item.Properties p = new Item.Properties();
        p.stacksTo(1);
        p.durability(1);
        return p;
    }

    public SoulWand() {
        super(SoulWand.createProps(), "soul_wand");
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand handIn) {
        BlockPos underPos;
        Block underBlock;
        ItemStack stack = player.getItemInHand(handIn);
        BlockHitResult hitresult = SoulWand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = hitresult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IHasFire) {
            this.changeFire(level, player, pos, state, (IHasFire)block);
        } else if (block instanceof FireBase && (underBlock = level.getBlockState(underPos = pos.below()).getBlock()) instanceof IHasFire) {
            this.changeFire(level, player, underPos, level.getBlockState(underPos), (IHasFire)underBlock);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    private void changeFire(Level level, Player player, BlockPos pos, BlockState state, IHasFire modblock) {
        FireTypes currentType = (FireTypes)((Object)state.getValue(IHasFire.FIRE_TYPE));
        FireTypes prevType = (FireTypes)((Object)state.getValue(IHasFire.PREVIOUS_FIRE_TYPE));
        if (prevType == FireTypes.SOUL) {
            prevType = FireTypes.NORMAL;
        }
        if (player.isSuppressingSlidingDownLadder()) {
            if (currentType == FireTypes.SOUL) {
                state = modblock.setFireType(level, pos, state, prevType, prevType);
                this.playSound(level, player, Wand.SoundEvents.UNDO, 0.6f);
            }
        } else if (currentType != FireTypes.SOUL) {
            state = modblock.setFireType(level, pos, state, FireTypes.SOUL, prevType);
            this.playSound(level, player, Wand.SoundEvents.CHANGE, 0.8f);
        }
        if (modblock instanceof Pedestal) {
            ((Pedestal)modblock).setFire(level, pos, state, true);
        }
    }
}

