/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.processor.ISafeWorldModifier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RedstoneProcessor
extends StructureProcessor
implements ISafeWorldModifier {
    public static final RedstoneProcessor INSTANCE = new RedstoneProcessor(Blocks.STONE_BRICKS);
    public static final MapCodec<RedstoneProcessor> CODEC = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("below_block").orElse((Object)Blocks.STONE_BRICKS).forGetter(processor -> processor.belowBlock)).apply((Applicative)codecBuilder, codecBuilder.stable(RedstoneProcessor::new)));
    private final Block belowBlock;

    private RedstoneProcessor(Block belowBlock) {
        this.belowBlock = belowBlock;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        Optional belowBlockState;
        if (blockInfoGlobal.state().is(Blocks.REDSTONE_WIRE) && ((belowBlockState = this.getBlockStateSafe(levelReader, blockInfoGlobal.pos().below())).isEmpty() || !((BlockState)belowBlockState.get()).isFaceSturdy((BlockGetter)levelReader, blockInfoGlobal.pos().below(), Direction.UP))) {
            this.setBlockStateSafe(levelReader, blockInfoGlobal.pos().below(), this.belowBlock.defaultBlockState());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.REDSTONE_PROCESSOR;
    }
}

