/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.SpikeCacheLoader;
import com.yungnickyoung.minecraft.betterendisland.world.processor.BlockReplaceProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterSpikeFeature {
    private static final LoadingCache<Long, List<SpikeFeature.EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());
    private static final List<StructureProcessor> PROCESSORS = List.of(new BlockReplaceProcessor(Blocks.ORANGE_TERRACOTTA.defaultBlockState(), new BlockStateRandomizer(Blocks.OBSIDIAN.defaultBlockState()).addBlock(Blocks.CRYING_OBSIDIAN.defaultBlockState(), 0.3f), false, false, false, false), new BlockReplaceProcessor(Blocks.MAGENTA_TERRACOTTA.defaultBlockState(), new BlockStateRandomizer(Blocks.AIR.defaultBlockState()).addBlock(Blocks.CRYING_OBSIDIAN.defaultBlockState(), 0.1f).addBlock(Blocks.OBSIDIAN.defaultBlockState(), 0.1f), false, false, false, false), new BlockReplaceProcessor(Blocks.PURPLE_CONCRETE.defaultBlockState(), new BlockStateRandomizer(Blocks.OBSIDIAN.defaultBlockState()), false, false, false, false), new DragonEggProcessor());

    public static List<SpikeFeature.EndSpike> getSpikesForLevel(WorldGenLevel level) {
        RandomSource randomSource = RandomSource.create((long)level.getSeed());
        long seed = randomSource.nextLong() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)seed);
    }

    public static void placeSpike(ServerLevelAccessor level, RandomSource randomSource, SpikeConfiguration config, SpikeFeature.EndSpike spike, boolean isInitialSpawn) {
        ServerLevel serverLevel;
        Pair<ResourceLocation, ResourceLocation> templates = BetterSpikeFeature.chooseTemplates(spike, isInitialSpawn, randomSource.nextFloat() < 0.2f);
        long seed = 0L;
        if (level instanceof WorldGenLevel) {
            seed = ((WorldGenLevel)level).getSeed();
        }
        RandomSource rand = RandomSource.create((long)(seed ^ (long)spike.getCenterX() ^ (long)spike.getCenterZ()));
        Rotation rotation = Rotation.getRandom((RandomSource)rand);
        int numberTimesDragonKilled = 0;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getDragonFight() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.getDragonFight()).betterendisland$numTimesDragonKilled();
        }
        int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
        BlockPos centerPos = new BlockPos(spike.getCenterX(), topY, spike.getCenterZ());
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos, rotation, (ResourceLocation)templates.getFirst(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place top spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos = centerPos.below(67), rotation, (ResourceLocation)templates.getSecond(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place bottom spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!isInitialSpawn) {
            EndCrystal endCrystal = (EndCrystal)EntityType.END_CRYSTAL.create((Level)level.getLevel());
            endCrystal.setBeamTarget(config.getCrystalBeamTarget());
            endCrystal.setInvulnerable(config.isCrystalInvulnerable());
            int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
            endCrystal.moveTo((double)spike.getCenterX() + 0.5, (double)crystalY, (double)spike.getCenterZ() + 0.5, randomSource.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity((Entity)endCrystal);
            level.setBlock(new BlockPos(spike.getCenterX(), crystalY - 1, spike.getCenterZ()), Blocks.BEDROCK.defaultBlockState(), 3);
        }
    }

    private static Pair<ResourceLocation, ResourceLocation> chooseTemplates(SpikeFeature.EndSpike spike, boolean isInitialSpawn, boolean isGuarded) {
        String pillarType = isInitialSpawn ? "initial" : (isGuarded ? "guarded" : "broken");
        int pillarHeight = (spike.getHeight() - 73) / 3;
        if (pillarHeight == 10) {
            pillarHeight = 9;
        }
        String topName = "pillar_" + pillarType + "_" + pillarHeight;
        String bottomName = "pillar_bottom_" + pillarHeight;
        ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
        return new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"betterendisland", (String)topName), (Object)ResourceLocation.fromNamespaceAndPath((String)"betterendisland", (String)bottomName));
    }

    private static boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, Rotation rotation, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.getLevel().getStructureManager().get(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.offset(-template.getSize().getX() / 2, 0, -template.getSize().getZ() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).addProcessor(arg_0));
        structurePlaceSettings.addProcessor((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.setRotation(rotation);
        structurePlaceSettings.setRotationPivot(new BlockPos(9, 0, 9));
        structurePlaceSettings.setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        template.placeInWorld(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

