/*
 * Decompiled with CFR 0.152.
 */
package waves.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import waves.Waves;

public class JsonHelpers {
    public static final String DEFAULT_VERSION = "0";

    public static ArtifactVersion getVersion() {
        return ((ModContainer)ModList.get().getModContainerById("waves").get()).getModInfo().getVersion();
    }

    public static int compareVersions(String oldVersion) {
        return ((ModContainer)ModList.get().getModContainerById("waves").get()).getModInfo().getVersion().compareTo((Object)new DefaultArtifactVersion(oldVersion));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readJsonFile(String filePath) {
        try (FileReader reader = new FileReader(filePath);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element == null) return null;
            if (!element.isJsonObject()) return null;
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject;
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JsonObject createFile(String filePath, String fileName, JsonObject data) {
        String path = filePath + File.separator + fileName + ".json";
        try (FileWriter file = new FileWriter(path);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String pretty = gson.toJson((JsonElement)data);
            file.write(pretty);
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JsonHelpers.readJsonFile(path);
    }

    public static double convertToDouble(JsonElement json, String memberName, double fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        Waves.LOGGER.error("Expected " + memberName + " to be a Double, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static double getAsDouble(JsonObject json, String memberName, double fallback) {
        return json.has(memberName) ? JsonHelpers.convertToDouble(json.get(memberName), memberName, fallback) : fallback;
    }

    public static int convertToInt(JsonElement json, String memberName, int fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        Waves.LOGGER.error("Expected " + memberName + " to be a Int, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static int getAsInt(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? JsonHelpers.convertToInt(json.get(memberName), memberName, fallback) : fallback;
    }

    public static boolean convertToBoolean(JsonElement json, String memberName, boolean fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        Waves.LOGGER.error("Expected " + memberName + " to be a Boolean, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static boolean getAsBoolean(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? JsonHelpers.convertToBoolean(json.get(memberName), memberName, fallback) : fallback;
    }

    public static String convertToString(JsonElement json, String memberName, String fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        Waves.LOGGER.error("Expected " + memberName + " to be a String, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static String getAsString(JsonObject json, String memberName, String fallback) {
        return json.has(memberName) ? JsonHelpers.convertToString(json.get(memberName), memberName, fallback) : fallback;
    }

    public static JsonArray convertListToJsonArray(List<String> list) {
        JsonArray jsonArray = new JsonArray();
        for (String item : list) {
            jsonArray.add((JsonElement)new JsonPrimitive(item));
        }
        return jsonArray;
    }

    public static List<String> convertJsonArrayToList(JsonArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            list.add(element.getAsString());
        }
        return list;
    }
}

